#' @export
variablelist <-
function(datadf, verbose=TRUE)
{
     #                          variablelist
     #
     # VALUE     List of 2-column matrices, each of which is a level of the level1 * level2 * level3 * . . . 
     #               possible levels of the character variables
     #
     # INPUT          datadf     Data frame of independent variables in analysis
     #                verbose
     #
     MC <- match.call()
     if(verbose) {
          print("", quote = FALSE)
          print("Running variablelist", quote = FALSE)
          print("", quote = FALSE)
          print(date(), quote = FALSE)
          print("", quote = FALSE)
          print("Call:", quote = FALSE)
          print(MC)
          print("", quote = FALSE)
     }
     dimdata <- dim(datadf)
     nrows <- dimdata[1]
     ncols <- dimdata[2]
     SubsetCode <- rep("_", nrows)
     for(j in 2:ncols){
          nlevs <- levels(datadf[,j])
          if(!is.null(nlevs)){
               for(i in 1:nrows){
                    SubsetCode[i] <- paste(SubsetCode[i], datadf[i,j], sep="_") 
               }
          }
     }
     Subsetsdf <- data.frame(datadf[,1], SubsetCode) 

     ###########################################################################################
     # Message regarding removal of observations when it is the only example of a factor level #
     ###########################################################################################
     tableSub <- table(SubsetCode)
     dntableSub <- dimnames(tableSub)$SubsetCode
     ncells <- length(tableSub)
     anyonlyone <- any(tableSub==1)
     if(anyonlyone){
          message("There is as least one instance where a level of the possibly crossed factors contains only 1 observation.")
          message("It may be necessary to remove any such observations before forsearch analysis.")
          message("The observations and their factor codes are:")
          for(i in 1:ncells){
               if(tableSub[[i]]==1){
                    singleobs <- Subsetsdf[Subsetsdf$SubsetCode==dntableSub[i],]
                    Hmisc::prn(singleobs)
               }     # if
          }     # for
#prn(Subsetsdf[order(SubsetCode),])
#stop("all")
     }     # anyonlyone
     uSubsetCode <- sort(unique(SubsetCode))
     nSC <- length(uSubsetCode)
     Subsetlist <- vector("list", nSC)
     names(Subsetlist) <- uSubsetCode
     for(i in 1:nSC){
          Subsetlist[[i]] <- Subsetsdf[Subsetsdf[,2] == uSubsetCode[i],]
     }
     if(verbose) {
          print("", quote = FALSE)
          print("Finished running variablelist", quote = FALSE)
          print("", quote = FALSE)
          print(date(), quote = FALSE)
          print("", quote = FALSE)
     }
     return(Subsetlist)
}
