% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_check.R
\name{format_check}
\alias{format_check}
\title{format_check}
\usage{
format_check(x, ranks, species = FALSE, species_sep = " ", verbose = TRUE)
}
\arguments{
\item{x}{A dataframe with hierarchically organised, taxonomic
information. If x only comprises the taxonomic information,}

\item{ranks}{does not need to be specified, but the columns
must be in order of decreasing taxonomic rank @param ranks
The column names of the taxonomic data fields in x. These
must be provided in order of decreasing taxonomic rank}

\item{species}{A logical indicating if x contains a species
column. As the data must be supplied in hierarchical order,
this column will naturally be the last column in x and
species-specific spell checks will be performed on this column.}

\item{species_sep}{A character vector of length one specifying
the genus name and specific epithet in the species column, if
present}

\item{verbose}{A logical determining if any flagged
errors should be reported to the console}
}
\value{
A list of two lists. The first list flags the row
indexes of columns whose elements contains non-letter characters.
The second list flags the row indexes  of columns whose elements
do not contain the correct numbers of words
}
\description{
Function to perform a series of basic formatting checks
geared towards taxonomic name data. The function very
simply checks for non letter characters in the taxonomic
names, that species-level names contain two words, and
genus-level and above names contain one word.
}
\examples{
# load dataset
data("brachios")
# define ranks
b_ranks <- c("phylum", "class", "order", "family", "genus")
# run function
flag <- format_check(brachios, ranks = b_ranks)
}
