% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.emfrail.R
\name{autoplot}
\alias{autoplot}
\alias{autoplot.emfrail}
\title{Plots for emfrail objects using \code{ggplot2}}
\usage{
autoplot(object, ...)

\method{autoplot}{emfrail}(object, type = c("hist", "hr", "pred", "frail"),
  newdata = NULL, lp = NULL, quantity = "cumhaz",
  type_pred = c("conditional", "marginal"), conf_int = "adjusted",
  individual = FALSE, ...)
}
\arguments{
\item{object}{\code{emfrail} object, typically result of \code{emfrail()}}

\item{...}{Further arguments to be passed on to `ggplot` (ignored)}

\item{type}{One (or more) of \code{hist} for a histogram of the estimated frailty values,
\code{hr} for a plot of the conditional and marginal hazard ratio between two cases,
\code{pred} for the predicted conditional and marginal cumulative hazard or survival for one case,
\code{frail} for a plot of the ordered frailty estimates with confidence intervals, where available.}

\item{newdata}{A \code{data.frame} with values of the covariates. For \code{type == "hr"} the hazard ratio
between the first two rows of \code{newdata} is calculated. For \code{type == "pred"} the prediction
for the first row of \code{newdata} is calculated.}

\item{lp}{A numeric vector of values of the linear predictor, each corresponding to a case. For \code{type == "hr"} the hazard ratio
between the first two values of \code{lp} is calculated. For \code{type == "pred"} the prediction
for the first value of \code{lp} is calculated.}

\item{quantity}{For \code{type == "pred"} the predicted quantity; see \code{quantity} in \code{\link{predict.emfrail}}}

\item{type_pred}{For \code{type == "pred"} the type of predicted quantity; see \code{type} in \code{\link{predict.emfrail}}}

\item{conf_int}{For \code{type == "pred"} the type of confidence intervals; see \code{conf_int} in \code{\link{predict.emfrail}}}

\item{individual}{For \code{type == "pred"} for drawing a curve when the rows of \code{newdata} refer to the same individual; see
\code{individual} in \code{\link{predict.emfrail}}}
}
\value{
A list of \code{ggplot2} objects corresponding to the required plots, or one \code{ggplot2} if only one plot is selected
}
\description{
Plots for emfrail objects using \code{ggplot2}
}
\examples{
mod_rec <- emfrail(Surv(start, stop, status) ~ treatment + number + cluster(id), bladder1)

# Histogram of the estimated frailties
autoplot(mod_rec, type = "hist")

# Ordered estimated frailties (with confidence intervals, for gamma distribution)
autoplot(mod_rec, type = "frail")

# hazard ratio between placebo and pyridoxine
newdata1 <- data.frame(treatment = c("placebo", "pyridoxine"),
                       number = c(1, 3))

autoplot(mod_rec, type = "hr", newdata = newdata1)

# predicted cumulative hazard for placebo, and number = 1
autoplot(mod_rec, type = "pred", newdata = newdata1[1,])

# predicted survival for placebo, and number = 1
autoplot(mod_rec, type = "pred", quantity = "survival", newdata = newdata1[1,])

# predicted survival for an individual that switches from
# placebo to pyridoxine at time = 15
newdata2 <- data.frame(treatment = c("placebo", "pyridoxine"),
                       number = c(1, 3),
                       tstart = c(0, 15),
                       tstop = c(15, Inf))

autoplot(mod_rec, type = "pred", quantity = "survival", newdata = newdata2, individual = TRUE)
}
\seealso{
\code{\link{predict.emfrail}}, \code{\link{summary.emfrail}}, \code{\link{plot.emfrail}}.
}
