% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.jointSurroPenal.R
\name{summary.jointSurroPenal}
\alias{summary.jointSurroPenal}
\alias{print.summary.jointSurroPenal}
\title{Short summary of the random effects parameters, the fixed treatment 
effects, and the surrogacy evaluation criteria estimated from a joint surrogate model}
\usage{
\method{summary}{jointSurroPenal}(object, d = 4, len = 3, int.method.kt = 0, 
nb.gh = 32, ...)
}
\arguments{
\item{object}{an object inheriting from \code{jointSurroPenal} class.}

\item{d}{The desired number of digits after the decimal point for parameters. 
The maximum of 4 digits is required for the estimates. Default of 3 digits is used.}

\item{len}{The desired number of digits after the decimal point for p-value and convergence 
criteria. Default of 4 digits is used.}

\item{int.method.kt}{A binary, indicates the integration method for Kendall's \eqn{\tau}
estimation : \code{0} for Monte carlo, and \code{1} for Gaussian Hermite quadrature. 
the default is \code{0}.}

\item{nb.gh}{Number of nodes for the Gaussian-Hermite quadrature.  The default is \code{32}
\code{1} for Gaussian-Hermite quadrature.}

\item{\dots}{other unused arguments.}
}
\value{
For the variances parameters of the random effects, it prints the estimate of
the coefficients with their standard error, Z-statistics and p-values
of the Wald test. For the fixed treatment effects, it also prints HR and its confidence
intervals for each covariate. For the surrogacy evaluation criteria, its prints the estimated 
Kendall's \eqn{\tau} with its 95\% Confidence interval obtained by the parametric bootstrap, 
the estimated \eqn{R^2_{trial}}(R2trial) with standard error and the 95\% Confidence interval 
obtained by Delta-method (Dowd \emph{et al.}, 2014), \eqn{R^2_{trial}}(R2.boot) and its 95\% 
Confidence interval obtained by the parametric bootstrap. 
We notice that, using the bootstrap, 
the standard error of the point estimate is not available. We propose a classification of \eqn{R^2_{trial}} according to a 
modification to surrogate criteria proposed by the Institute of Quality and Efficiency in Health Care 
(Prasad \emph{et al.}, 2015). 
We also display the surrogate threshold effect (\code{\link[=ste]{STE}}) with the associated hazard risk.
The rest of parameters concerns the convergence characteristics and 
included: the penalized marginal log-likelihood, number of iterations, the LCV and the Convergence criteria.
}
\description{
This function returns the estimate of the coefficients and their standard error with p-values 
of the Wald test for the joint surrogate model, also hazard ratios (HR) and their 
confidence intervals for the fixed treatment effects, and finaly an estimate of the 
surrogacy evaluation criterian (Kendall's \eqn{\tau} and \eqn{R^2_{trial}})
}
\examples{



###---Data generation---###
data.sim <-jointSurrSimul(n.obs=400, n.trial = 20,cens.adm=549, 
          alpha = 1.5, theta = 3.5, gamma = 2.5, zeta = 1, 
          sigma.s = 0.7, sigma.t = 0.7,rsqrt = 0.8, betas = -1.25, 
          betat = -1.25, full.data = 0, random.generator = 1, 
          seed = 0, nb.reject.data = 0)
\dontrun{
###---Estimation---###
joint.surrogate <- jointSurroPenal(data = data.sim, nb.mc = 300, 
                   nb.gh = 20, indicator.alpha = 1, n.knots = 6)
                            
summary(joint.surrogate)
summary(joint.surrogate, d = 4, len = 3, int.method.kt = 1, nb.gh = 25)
}


}
\references{
Dowd BE, Greene WH, Norton EC (2014). "Computation of Standard Errors." Health Services
Research, 49(2), 731-750.

Prasad V, Kim C, Burotto M, Vandross A (2015). "The strength of association between
surrogate end points and survival in oncology: A systematic review of trial-level meta-
alyses." JAMA Internal Medicine, 175(8), 1389-1398.
}
\seealso{
\code{\link{jointSurroPenal} \link{jointSurroTKendall}}
}
\author{
Casimir Ledoux Sofeu \email{casimir.sofeu@u-bordeaux.fr}, \email{scl.ledoux@gmail.com} and 
Virginie Rondeau \email{virginie.rondeau@inserm.fr}
}
\keyword{methods}
