% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulatejointRecCompet.R
\name{simulatejointRecCompet}
\alias{simulatejointRecCompet}
\title{Generating from a joint competing Joint frailty model with a recurrent event and two
terminal events.}
\usage{
simulatejointRecCompet(n, censoring = 28, maxrecurrent = 50, 
           par0 = c(shapeR = 1.5, scaleR = 10, 
           shapeM = 1.75, scaleM = 16, 
           shapeD = 1.75, scaleD = 16, 
           sigma = 0.5, alphaM = 1, alphaD = 0, 
           betaR = -0.5, betaM = -0.5, betaD = 0))
}
\arguments{
\item{n}{Number of subjects. Default is 1500.}

\item{censoring}{A number indicating a fixed right censoring time for all subjects 
(as an administrative censoring). If \code{NULL}, no censoring is applied. 
Default is 28.}

\item{maxrecurrent}{Maximum number of recurrent events per subject.
If \code{NULL}, no upper bound is set for the number of of recurrent events
Default is 50.}

\item{par0}{A vector of arguments controlling the parameters of the generating model. 
 \itemize{
  \item{\code{shapeR}: \code{shape} parameter of the Weibull distribution for the recurrent event}
  \item{\code{scaleR}: \code{scale} parameter of the Weibull distribution for the recurrent event} 
  \item{\code{shapeT1}: \code{shape} parameter of the Weibull distribution for the first terminal event}
  \item{\code{scaleT1}: \code{scale} parameter of the Weibull distribution for the first terminal event}
  \item{\code{shapeT2}: \code{shape} parameter of the Weibull distribution for the second terminal event}
  \item{\code{scaleT2}: \code{scale} parameter of the Weibull distribution for the second terminal event}
  \item{\code{sigma}: Standard deviation of the frailty}
  \item{\code{alphaT1}: Power parameter (link) of the frailty for the first terminal event}
  \item{\code{alphaT2}: Power parameter (link) of the frailty for the second terminal event}
  \item{\code{betaR}: Association parameter for the treatment effect on the recurrent event}
  \item{\code{betaT1}: Association parameter for the treatment effect on the first terminal event}
  \item{\code{betaT2}: Association parameter for the treatment effect on the second terminal event}
}}
}
\value{
Returns a \code{data.frame} object with the following columns:
\itemize{
 \item{\code{id} Id number for each subject}
 \item{\code{treatment} Binary treatment indicator} 
 \item{\code{tstart} Start time of the observation period}
 \item{\code{tstop} Stop time of the observation period}
 \item{\code{recurrent} Censoring indicator for the recurrent event}
 \item{\code{terminal1} Censoring indicator for the first terminal event}
 \item{\code{terminal2} Censoring indicator for the second terminal event}
}
}
\description{
Generates data under a joint frailty model for a single recurrent event
and two terminal events in a calendar-time format. Only a single covariate representing the treatment
is allowed. Event times are generated under Weibull distributions.
}
\seealso{
\link{jointRecCompet}
}
