## ----message=F, warning=F-----------------------------------------------------
library(frameCleaneR)
library(printr)
library(dplyr)

## -----------------------------------------------------------------------------
tibble::tibble(
  date = c("20190101", "20190305", "20201012"),
  numeric_val = c(1, NA, 5),
  char_val = c("", "    val ", "-")
) -> sample_table

sample_table

## -----------------------------------------------------------------------------
sample_table %>% 
  set_na(everything())

## -----------------------------------------------------------------------------
sample_table %>% 
  remove_whitespace(where(is.character))

## -----------------------------------------------------------------------------
sample_table %>% 
  set_dates(everything())

## -----------------------------------------------------------------------------
sample_table %>% 
  relocate_all()

## -----------------------------------------------------------------------------
sample_table %>% 
  clean_frame()

## -----------------------------------------------------------------------------
sample_table %>% 
  fill_na(where(is.numeric))

## -----------------------------------------------------------------------------
iris %>% 
  summarize(across(where(is.numeric), mean), .groups = "drop") -> sumr0

sumr0

## -----------------------------------------------------------------------------

sumr0 %>% 
  pivot_summary()


## -----------------------------------------------------------------------------
iris %>% 
  group_by(Species) %>% 
  summarize(across(where(is.numeric), mean), .groups = "drop") -> sumr1

sumr1

## -----------------------------------------------------------------------------

sumr1 %>% 
  pivot_summary(Species)

