% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mris_convert_curv.R
\name{mris_convert_curv}
\alias{mris_convert_curv}
\title{Convert Curvature file}
\usage{
mris_convert_curv(curv, opts = "", ...)
}
\arguments{
\item{curv}{(character) scalar curv overlay file}

\item{opts}{(character) additional options to 
\code{\link{mris_convert}}}

\item{...}{additional arguments to \code{\link{mris_convert}}}
}
\value{
Result of \code{\link{mris_convert}}
}
\description{
This function call \code{mris_convert}, 
using the \code{-c} option
}
\examples{
if (have_fs()) {
 bert_surf_dir = file.path(fs_subj_dir(), "bert", "surf")
 asc_file = mris_convert_curv(
 infile = file.path(bert_surf_dir, "lh.white"),
 curv = file.path(bert_surf_dir, "lh.thickness")
 )  
 res = read_fs_table(asc_file, header = FALSE)
 colnames(res) = c("index", "coord_1", "coord_2", "coord_3", "value")
 head(res)
}  
}
