% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_surface.R
\name{surface_to_obj}
\alias{surface_to_obj}
\title{Convert Freesurfer Surface to Wavefront OBJ}
\usage{
surface_to_obj(infile, outfile = NULL, ...)
}
\arguments{
\item{infile}{Input surface file}

\item{outfile}{output Wavefront OBJ file.  If \code{NULL}, 
a temporary file will be created}

\item{...}{additional arguments to pass to 
\code{\link{convert_surface}}}
}
\value{
Character filename of output file
}
\description{
Reads in a surface file from Freesurfer and converts it
to a Wavefront OBJ file
}
\examples{
if (have_fs()) {
infile = file.path(fs_subj_dir(), 
                   "bert", "surf", "rh.pial")
res = surface_to_obj(infile = infile)
}
}
