% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_atlas_region_agg.R
\name{fs.atlas.region.agg.group}
\alias{fs.atlas.region.agg.group}
\title{Aggregate morphometry data over brain atlas regions and subjects for a group of subjects.}
\usage{
fs.atlas.region.agg.group(subjects_dir, subjects_list, measure, hemi,
  atlas, agg_fun = mean)
}
\arguments{
\item{subjects_dir, }{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subjects_list, }{string vector. A vector of subject identifiers that match the directory names within subjects_dir.}

\item{measure, }{string. Name of the vertex-wise measure of morphometry data file. E.g., "area" or "thickness". Used to construct the name of the morphometry file to be loaded.}

\item{hemi, }{string, one of 'lh' or 'rh'. The hemisphere name. Used to construct the names of the annotation and morphometry data files to be loaded.}

\item{atlas, }{string. The atlas name. E.g., "aparc", "aparc.2009s", or "aparc.DKTatlas". Used to construct the name of the annotation file to be loaded.}

\item{agg_fun, }{function. An R function that aggregates data, typically max, mean, min or something similar. Note: this is NOT a string, put the function name without quotes. Defaults to mean.}
}
\value{
dataframe with aggregated values for all regions and subjects, with n columns and m rows, where n is the number of subjects and m is the number of regions.
}
\description{
Aggregate morphometry data over brain atlas regions, e.g., compute the mean thickness value over all regions in an atlas for all subjects.
}
\keyword{internal}
