% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mghheader.R
\name{mghheader.is.ras.valid}
\alias{mghheader.is.ras.valid}
\title{Check whether header contains valid ras information}
\usage{
mghheader.is.ras.valid(header)
}
\arguments{
\item{header}{mgh header or `fs.volume` instance with header}
}
\value{
logical, whether header contains valid ras information (according to the `ras_good_flag`).
}
\description{
Check whether header contains valid ras information
}
\examples{
    brain_image = system.file("extdata", "brain.mgz",
                               package = "freesurferformats",
                               mustWork = TRUE);
    vdh = read.fs.mgh(brain_image, with_header = TRUE);
    mghheader.is.ras.valid(vdh$header);

}
\seealso{
Other header coordinate space: 
\code{\link{mghheader.ras2vox.tkreg}()},
\code{\link{mghheader.ras2vox}()},
\code{\link{mghheader.scanner2tkreg}()},
\code{\link{mghheader.tkreg2scanner}()},
\code{\link{mghheader.vox2ras.tkreg}()},
\code{\link{mghheader.vox2ras}()},
\code{\link{read.fs.transform}()}
}
\concept{header coordinate space}
