% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_fs_label.R
\name{write.fs.label.gii}
\alias{write.fs.label.gii}
\title{Write a binary surface label in GIFTI format.}
\usage{
write.fs.label.gii(filepath, vertex_indices, num_vertices_in_surface)
}
\arguments{
\item{filepath}{string, the full path of the output GIFTI file.}

\item{vertex_indices}{integer vector, the vertex indices which are part of the label (positive). All others not listed, up to num_vertices_in_surface, will be set to be negative.}

\item{num_vertices_in_surface}{integer, the total number of vertices in the surface mesh. A GIFTI label is more like a mask/an annotation, so we need to know the number of vertices.}
}
\value{
format, string. The format that was used to write the data: "gii".
}
\description{
The data will be written with intent 'NIFTI_INTENT_LABEL' and as datatype 'NIFTI_TYPE_INT32'. The label table will include entries 'positive' (label value 0), and 'negative' (label value 1).
}
\examples{
  label = c(1L, 23L, 44L); # the positive vertex indices
  outfile = tempfile(fileext=".gii");
  write.fs.label.gii(outfile, label, 50L);

}
\seealso{
Other morphometry functions: 
\code{\link{fs.get.morph.file.ext.for.format}()},
\code{\link{fs.get.morph.file.format.from.filename}()},
\code{\link{read.fs.curv}()},
\code{\link{read.fs.mgh}()},
\code{\link{read.fs.morph.gii}()},
\code{\link{read.fs.morph}()},
\code{\link{read.fs.volume}()},
\code{\link{read.fs.weight}()},
\code{\link{write.fs.curv}()},
\code{\link{write.fs.mgh}()},
\code{\link{write.fs.morph.asc}()},
\code{\link{write.fs.morph.gii}()},
\code{\link{write.fs.morph.smp}()},
\code{\link{write.fs.morph.txt}()},
\code{\link{write.fs.morph}()},
\code{\link{write.fs.weight.asc}()},
\code{\link{write.fs.weight}()}

Other gifti writers: 
\code{\link{write.fs.annot.gii}()},
\code{\link{write.fs.morph.gii}()},
\code{\link{write.fs.surface.gii}()}
}
\concept{gifti writers}
\concept{morphometry functions}
