% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_nifti2.R
\name{read.nifti2.data}
\alias{read.nifti2.data}
\title{Read raw data from NIFTI v2 file.}
\usage{
read.nifti2.data(filepath, header = NULL, drop_empty_dims = TRUE)
}
\arguments{
\item{filepath}{path to a NIFTI v2 file.}

\item{header}{optional nifti v2 header obtained from \code{\link{read.nifti2.header}}. Will be loaded automatically if left at `NULL`.}

\item{drop_empty_dims}{logical, whether to drop empty dimensions in the loaded data array.}
}
\value{
the data in the NIFTI v2 file. Note that the NIFTI v2 header information (scaling, units, etc.) is not applied in any way: the data are returned raw, as read from the file. The information in the header is used to read the data with the proper data type and size.
}
\description{
Read raw data from NIFTI v2 file.
}
