% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timedom.norms.R
\name{timedom.norms}
\alias{timedom.norms}
\title{Compute operator norms of elements of a filter}
\usage{
timedom.norms(A, type = c("2", "O", "I", "F", "M"))
}
\arguments{
\item{A}{an object of class \code{timedom}}

\item{type}{matrix norm to be used as in \code{norm}}
}
\value{
A list which contains the following components:
\itemize{
\item \code{lags} \eqn{\quad} a vector containing the lags of \code{A}.
\item \code{norms} \eqn{\quad} a vector containing the norms of the matrices defining \code{A}.
}
}
\description{
This function determines the norms of the matrices defining some linear filter.
}
\details{
Computes \eqn{\|A_h\|} for \eqn{h} in the set of lags belonging to the object A. When type
is \code{2} then \eqn{\|A\|} is the spectral radius of \eqn{A}. When type is \code{F}
then \eqn{\|A\|} is the Frobenius norm (or the Hilbert-Schmidt norm, or Schatten 2-norm) of
\eqn{A}. Same options as for the function \code{norm} as in base package.
}
\examples{
d = 2

A = array(0,c(d,d,2))
A[1,,] = 2 * diag(d:1)/d
A[2,,] = 1.5 * diag(d:1)/d
OP = timedom(A,c(-2,1))
timedom.norms(OP)
}
\keyword{time.domain}
