% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-adminlte.R
\name{adminlte_sidebar}
\alias{adminlte_sidebar}
\title{AdminLTE CSS sidebar variables}
\usage{
adminlte_sidebar(width = NULL, dark_bg = NULL, dark_hover_bg = NULL,
  dark_color = NULL, dark_hover_color = NULL, dark_submenu_bg = NULL,
  dark_submenu_color = NULL, dark_submenu_hover_color = NULL,
  light_bg = NULL, light_hover_bg = NULL, light_color = NULL,
  light_hover_color = NULL, light_submenu_bg = NULL,
  light_submenu_color = NULL, light_submenu_hover_color = NULL)
}
\arguments{
\item{width}{Side bar width, default to \code{230px}.}

\item{dark_bg}{Background color (dark mode).}

\item{dark_hover_bg}{Background hover color (dark mode).}

\item{dark_color}{Text color (dark mode).}

\item{dark_hover_color}{Text hover color (dark mode).}

\item{dark_submenu_bg}{Background sub-menu color (dark mode).}

\item{dark_submenu_color}{Text sub-menu color (dark mode).}

\item{dark_submenu_hover_color}{Text sub-menu hover color (dark mode).}

\item{light_bg}{Background color (light mode).}

\item{light_hover_bg}{Background hover color (light mode).}

\item{light_color}{Text color (light mode).}

\item{light_hover_color}{Text hover color (light mode).}

\item{light_submenu_bg}{Background sub-menu color (light mode).}

\item{light_submenu_color}{Text sub-menu color (light mode).}

\item{light_submenu_hover_color}{Text sub-menu hover color (light mode).}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
Those variables can be used to customize
 the sidebar in {shinydashboard}.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinydashboard)

  ui <- dashboardPage(
    header = dashboardHeader(title = "My dashboard"),
    sidebar = dashboardSidebar(
      sidebarMenu(
        menuItem("Dashboard", tabName = "dashboard", icon = icon("dashboard")),
        menuItem("Widgets", icon = icon("th"), tabName = "widgets", badgeLabel = "new",
                 badgeColor = "green"),
        menuItem("Charts", icon = icon("bar-chart-o"),
                 menuSubItem("Sub-item 1", tabName = "subitem1"),
                 menuSubItem("Sub-item 2", tabName = "subitem2")
        )
      )
    ),
    body = dashboardBody(

      use_theme(create_theme(
        adminlte_sidebar(
          dark_bg = "#F5A9A9",
          dark_hover_bg = "#8A0808"
        )
      ))
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
