% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_not_false.R
\name{is_not_false}
\alias{is_not_false}
\title{Test if an Object is Not False}
\usage{
is_not_false(object, null_is_false = TRUE, ...)
}
\arguments{
\item{object}{The object to be tested.}

\item{null_is_false}{Should NULL be treated as FALSE?}

\item{...}{Parameters passed to \code{\link{exists}}. See Examples.}
}
\value{
TRUE if the object is set to something different than FALSE, FALSE
otherwise.
}
\description{
Sometimes you need to know whether or not an object exists and is not set to
FALSE (and possibly not NULL).
}
\examples{
a  <- 1
is_not_false(a)
f <- function() {
    print(a)
    print(is_not_false(a))
}
f()

f <- function() {
    a <- FALSE
    print(a)
    print(is_not_false(a))
}
f()

f <- function() {
    print(a)
    print(is_not_false(a, null_is_false = TRUE,
                       inherits = FALSE))
}
f()
}
\keyword{internal}
