% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_code_file.R
\name{split_code_file}
\alias{split_code_file}
\title{Split a Code File Into Multiple Files Each Containing a Single Function}
\usage{
split_code_file(
  file,
  output_directory = tempdir(),
  encoding = getOption("encoding"),
  write_to_disk = getOption("write_to_disk")
)
}
\arguments{
\item{file}{The code file to be split.}

\item{output_directory}{Where to create the new files.}

\item{encoding}{The encoding passed to \code{\link{source}}.}

\item{write_to_disk}{Set the output_directory to
\code{dirname(output_directory)}? Just a shortcut.}
}
\value{
\code{\link[base:invisible]{Invisibly}} a vector of paths to the new
files.
}
\description{
I tend to find files with dozens of functions. They don't read well.
}
\examples{
infile <- system.file("files", "test_helpers.R", package = "fritools")
\dontrun{
   file.show(infile)
}
paths <- split_code_file(file = infile)
\dontrun{
   file.show(paths[2])
}
}
