% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memory_hogs.R
\name{memory_hogs}
\alias{memory_hogs}
\title{Find Memory Hogs}
\usage{
memory_hogs(
  unit = c("b", "Kb", "Mb", "Gb", "Tb", "Pb"),
  return_numeric = TRUE,
  ...,
  envir = .GlobalEnv
)
}
\arguments{
\item{unit}{The unit to use.}

\item{return_numeric}{Return a numeric vector? If set to
\code{\link{FALSE}}, a character vector including the unit will be returned,
which might be less usable but easier to read.}

\item{...}{Arguments passed to \code{\link{order}}, defaults to
\code{decreasing = FALSE}.}

\item{envir}{The environment where to look for objects.}
}
\value{
A named vector of memory usages.
}
\description{
List objects in an \R environment by size.
}
\examples{
va <- rep(mtcars, 1)
vb <- rep(mtcars, 1000)
vc <- rep(mtcars, 2000)
vd <- rep(mtcars, 100)
memory_hogs()
memory_hogs(unit = "Mb", decreasing = TRUE)
memory_hogs(unit = "Mb", decreasing = TRUE, return_numeric = FALSE)
\dontrun{
# remove the two largest objects:
rm(list = names(tail(memory_hogs(decreasing = FALSE), n = 2)))
memory_hogs(unit = "Mb")
}
}
\seealso{
Other R memory functions: 
\code{\link{wipe_clean}()}
}
\concept{R memory functions}
