% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GDD_linear.R
\name{GDD_linear}
\alias{GDD_linear}
\title{Calculates growing degree days (GDD) using a linear method}
\usage{
GDD_linear(Temp_Day, Tb, Tu = 999)
}
\arguments{
\item{Temp_Day}{a dataframe of daily temperatures. This data frame must
have a column for Year, Month, Day, and daily minimum (Tmin) and
maximum (Tmax) temperatures.}

\item{Tb}{the base temperature required to calculate GDD.}

\item{Tu}{an optional upper temperature threshold.}
}
\value{
dataframe consisting of the columns Year, Month, Day, Tmax, Tmin,
Tmean and GDD.
}
\description{
The function calculates the daily heat unit accumulation (GDD)
from daily temperature data with a linear method based on averaging
the daily maximum and minimum temperatures (Arnold, 1960). GDD are
calculated by subtracting the plant's lower base temperature (Tb) 
from the average daily air temperature. The user can define an upper 
temperature threshold (Tu) so that all temperatures above Tu will 
have equal value in GDD summation.
}
\examples{

# Calculate GDD in the example dataset using 4.5ÂºC as base temperature and no 
# upper threshold.
library(tidyverse)
GDD <- GDD_linear(Tudela_DW,4.5)
# Calculate GDD in the example dataset using 4.5ÂºC as base temperature and an 
# upper threshold at 25ÂºC.
GDD <- GDD_linear(Tudela_DW,4.5,25)


}
\references{
Arnold,  C.Y.  1960.  Maximum-minimum temperatures as a basis for computing
heat units. Proc.Amer. Soc. Hort. Sci. 76:682–692.
}
\author{
Carlos Miranda, \email{carlos.miranda@unavarra.es}
}
