% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cool_night_index.R
\name{coolness_index}
\alias{coolness_index}
\title{Calculation of night coolness index}
\usage{
coolness_index(climdata, harvest, span = 30)
}
\arguments{
\item{climdata}{a dataframe with daily maximum and minimum temperatures.
Must contain the columns Year, Month, Day, Tmax, Tmin.}

\item{harvest}{a vector with expected harvest days
(expressed as day of the year)}

\item{span}{the period (in days) before harvest that will be analyzed. By 
default, this parameter is set in 30 days.}
}
\value{
dataframe with the values of the indices. It contains the
columns Year, Harvest, Coolness
}
\description{
This function calculates a night coolness index based in the
Cool Night index of Tonietto (1999). Instead of calculating 
the mean of minimum temperatures in September/March (Northern
or Southern hemispheres, respectively), this function allows 
to define the harvest date and the number of days that will be
analyzed (by default, 30 days), and calculates the mean of minimum
temperatures in the in the specified period of days before harvest.
The function allows testing for several harvest dates simultaneously.
}
\examples{

# Select the appropiate columns from the Tudela_DW example dataset,
# create a vector or harvest dates and estimate the coolness index 
# for the 30 days prior to harvest on each year in the dataset.
library(tidyverse)
Weather <- Tudela_DW \%>\%
   select(Year, Month, Day, Tmax, Tmin)
harvest <- c(225, 250, 275)
coolness <- coolness_index(Weather, harvest)

}
\references{
Tonietto J. 1999. Les macroclimats viticoles mondiaux et l'influence du
mésoclimat sur la typicité de la Syrah et du Muscat de Hambourg dans le
sud de la France: methodologie de carácterisation. Thése Doctorat. Ecole 
Nationale Supérieure Agronomique, Montpellier, 233pp.
}
\author{
Carlos Miranda, \email{carlos.miranda@unavarra.es}
}
