% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brainview_magick.R
\name{vislayout.from.coloredmeshes}
\alias{vislayout.from.coloredmeshes}
\title{Visualize coloredmeshes from several angles and combine the images into a new figure.}
\usage{
vislayout.from.coloredmeshes(coloredmeshes,
  view_angles = get.view.angle.names(angle_set = "t4"),
  rgloptions = list(), rglactions = list(),
  output_img = "fsbrain_arranged.png", silent = FALSE,
  grid_like = TRUE)
}
\arguments{
\item{coloredmeshes, }{list of coloredmesh. A coloredmesh is a named list as returned by the `coloredmesh.from*` functions (like \code{\link[fsbrain]{coloredmesh.from.morph.native}}). It has the entries 'mesh' of type tmesh3d, a 'col', which is a color specification for such a mesh. The `vis*` functions (like \code{\link[fsbrain]{vis.subject.morph.native}}) all return a list of coloredmeshes.}

\item{view_angles}{list of strings. See \code{\link[fsbrain]{get.view.angle.names}} for all valid strings.}

\item{rgloptions}{option list passed to \code{\link[rgl]{par3d}}. Example: \code{rgloptions = list("windowRect"=c(50,50,1000,1000))}.}

\item{rglactions}{named list. A list in which the names are from a set of pre-defined actions. The values can be used to specify parameters for the action.}

\item{output_img}{string, path to the output file. Defaults to "fsbrain_arranged.png"}

\item{silent}{logical, whether to suppress all messages}

\item{grid_like}{logical, whether to arrange the images in a grid-like fashion. If FALSE, they will all be merged horizontally. Passed to \code{\link[fsbrain]{arrange.brainview.images}}.}
}
\value{
list of coloredmeshes. The coloredmeshes used for the visualization.
}
\description{
Create a tight layout view of coloredmeshes from several angles. Creates separate `sd_<angle>` images, then crops and finally merges them into a single output image with image magick. The `coloredmeshes` to pass to this function are usually obtained by running any `vis*` function (like \code{\link[fsbrain]{vis.subject.morph.native}}, \code{\link[fsbrain]{vis.subject.morph.standard}}, \code{\link[fsbrain]{vis.subject.label}}, \code{\link[fsbrain]{vis.subject.annot}}, and others). That means you can use this function to visualize all kinds of data, e.g., morphometry data in native and standard space, labels, and brain atlases.
}
\examples{
\donttest{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   # Use any vis function to get coloredmeshes. You can visualize morphometry,
   #  labels, an atlas, whatever. You can suppress the view unless you need it.
   coloredmeshes = vis.subject.morph.native(subjects_dir, "subject1", "thickness",
    cortex_only=TRUE, rglactions=list("clip_data"=c(0.05, 0.95)),
    views=NULL);
   # The meshes contain the surface, data, and color information and can be visualized:
   vislayout.from.coloredmeshes(coloredmeshes);
}


}
\seealso{
Other visualization functions: \code{\link{vis.data.on.fsaverage}},
  \code{\link{vis.data.on.subject}},
  \code{\link{vis.labeldata.on.subject}},
  \code{\link{vis.mask.on.subject}},
  \code{\link{vis.region.values.on.subject}},
  \code{\link{vis.subject.annot}},
  \code{\link{vis.subject.label}},
  \code{\link{vis.subject.morph.native}},
  \code{\link{vis.subject.morph.standard}}
}
\concept{visualization functions}
