% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curvature.R
\name{principal.curvatures}
\alias{principal.curvatures}
\title{Computes principal curvatures according to 2 definitions from raw k1 and k2 values.}
\usage{
principal.curvatures(k1_raw, k2_raw)
}
\arguments{
\item{k1_raw}{numerical vector, one of the two principal curvatures, one value per vertex}

\item{k2_raw}{numerical vector, the other one of the two principal curvatures, one value per vertex}
}
\value{
a named 'principal_curvatures' list, with entries 'principal_curvature_k1': larger value of k1_raw, k2_raw. 'principal_curvature_k2': smaller value of k1_raw, k2_raw. 'principal_curvature_k_major': larger value of abs(k1_raw), abs(k2_raw). 'principal_curvature_k_minor': smaller value of abs(k1_raw), abs(k2_raw).
}
\description{
Computes principal curvatures according to 2 definitions from raw k1 and k2 values.
}
