% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{vdata.split.by.hemi}
\alias{vdata.split.by.hemi}
\title{Split morph data vector at hemisphere boundary.}
\usage{
vdata.split.by.hemi(
  subjects_dir,
  subject_id,
  vdata,
  surface = "white",
  expand = TRUE
)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id}{string. The subject identifier}

\item{vdata}{numerical vector of data for both hemispheres, one value per vertex}

\item{surface}{the surface to load to determine the vertex counts}

\item{expand}{logical, whether to allow input of length 1, and expand (repeat) it to the length of the hemispheres.}
}
\value{
a hemilist, each entry contains the data part of the respective hemi.
}
\description{
Given a single vector of per-vertex data for a mesh, split it at the hemi boundary. This is achieved by loading the respective surface and checking the number of vertices for the 2 hemispheres.
}
\note{
Instead of calling this function to split the data, you could use the 'split_by_hemi' parameter of \code{\link[fsbrain]{subject.morph.native}}.
}
