% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth.R
\name{extend_neighbors}
\alias{extend_neighbors}
\title{Recursive computation of neighborhoods, see surf.sphere.dist}
\usage{
extend_neighbors(
  spherical_surface,
  targetvidx,
  currentvidx,
  min_dotp_thresh,
  ref_visited,
  ref_neighbors,
  ref_neighbor_dpdists
)
}
\arguments{
\item{spherical_surface}{an fs.surface instance representing the spherical version (\code{lh.sphere} or \code{rh.sphere} of the subject).}

\item{targetvidx}{positive integer, initial target vertex. The vertex for which to compute the neighborhood.}

\item{currentvidx}{positive integer, initial current vertex. Pass identical value as in targetvidx, this is changed later in the recursion.}

\item{ref_visited}{pass-by-reference (via RefClasses) integer vector of length \code{num_mesh_vertices}: whether the respective vertex has been visited already.}

\item{ref_neighbors}{pass-by-reference (via RefClasses) integer vector of length \code{num_mesh_vertices}: whether the respective vertex is part of the current neighborhood.}

\item{ref_neighbor_dpdists}{pass-by-reference (via RefClasses) double vector of length \code{num_mesh_vertices}: the dotproduct distance to the respective vertex (if it is part of the neighborhood).}

\item{min_dotp_threshold}{double, the minimal dotproduct distance threshold to use. Only vertices along the structural mesh neighborhood with values greater this will be included in the neighborhood. Yes, greater.}
}
\value{
integer, invisible. Either \code{0L} or \code{1L}. Used in the recursion only, ignore. The return values of interest are in the 3 \code{ref_*} parameters.
}
\description{
Compute neighborhood of the current vertex (=target vertex). The computation follows the mesh edges while there are still vertices which fullfil the dotproduct distance threshold.
}
\keyword{internal}
