% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth.R
\name{surf.sphere.gaussianweights}
\alias{surf.sphere.gaussianweights}
\title{Compute Gaussian weights}
\usage{
surf.sphere.gaussianweights(spherical_surface, sphere_dists, gstd)
}
\arguments{
\item{spherical_surface}{an fs.surface instance representing the spherical version (\code{lh.sphere} or \code{rh.sphere} of the subject).}

\item{sphere_dists}{list of vectors, as returned by surf.sphere.dist}

\item{gstd}{double, Gaussian standard deviation, can be computed from the FWHM as \code{gstd = fwhm / sqrt(log(256.0))}.}
}
\value{
vector of Gaussian weights for vertices
}
\description{
Compute Gaussian weights
}
\examples{
\dontrun{
fwhm = 20.0; truncfactor = 3.5; sjd = fsaverage.path();
gstd = fwhm / sqrt(log(256.0)); maxdist = truncfactor * gstd;
spherical_surface = subject.surface(sjd, "fsaverage3", surface="sphere", hemi="lh");
sphere_dists = surf.sphere.dist(spherical_surface, maxdist = maxdist);
gaussian_weights = fsbrain:::surf.sphere.gaussianweights(spherical_surface,
 sphere_dists, gstd);
morph_data = rep(NA, nrow(spherical_surface$vertices));
morph_data[sphere_dists$neigh[[500]]] = gaussian_weights[[500]];
vis.data.on.subject(sjd, "fsaverage3", morph_data_lh=morph_data);
}

}
\keyword{internal}
