% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fslhd.R
\name{fslsub2}
\alias{fslsub2}
\title{Subsample image by factor of 2}
\usage{
fslsub2(file, outfile = NULL, retimg = TRUE, reorient = FALSE,
  intern = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{file}{(character) filename of image to be subsampled}

\item{outfile}{(character) name of resultant subsampled file}

\item{retimg}{(logical) return image of class nifti}

\item{reorient}{(logical) If retimg, should file be reoriented when read in?
Passed to \code{\link{readnii}}.}

\item{intern}{(logical) pass to \code{\link{system}}}

\item{verbose}{(logical) print out command before running}

\item{...}{additional arguments passed to \code{\link{readnii}}.}
}
\value{
character or logical depending on intern
}
\description{
This function calls \code{fslmaths -subsamp2} to subsample an image
and either saves the image or returns an object of class nifti
}
\examples{
if (have.fsl()){
system.time({
x = array(rnorm(1e6), dim = c(100, 100, 100))
img = nifti(x, dim= c(100, 100, 100), 
datatype = convert.datatype()$FLOAT32, cal.min = min(x), 
cal.max = max(x), pixdim = rep(1, 4))
subsamp = fslsub2(img, retimg=TRUE)
print(voxdim(subsamp))
})
} 
}

