% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solver.R
\name{multiRegression}
\alias{multiRegression}
\title{multiRegression}
\usage{
multiRegression(Xs, Ys, Sk, gamma, n, p, k, trans = FALSE)
}
\arguments{
\item{Xs}{eQTL matrices. eQTL matrix can be matrix/list of multiple conditions}

\item{Ys}{Gene expression matrices}

\item{Sk}{eQTL index of genes}

\item{gamma}{Hyperparameter for ridge regression}

\item{n}{number of observations}

\item{p}{number of genes}

\item{k}{number of eQTLs}

\item{trans}{if rows for sample, trans = TRUE, otherwise, trans = FALSE. Default FALSE}
}
\value{
fit List of SEM model
\describe{
\item{Bs}{ coefficient matrices of gene regulatory networks}
\item{fs}{ eQTL's coefficients w.r.t each gene}
\item{Fs}{ coefficient matrices of eQTL-gene effect}
\item{mu}{ Bias vector}
\item{sigma2}{ estimate of covariance in SEM}
}
}
\description{
Ridge regression on multiple conditions, initialization of FSSEM algorithm
}
\examples{
seed = 1234
N = 100                                           # sample size
Ng = 5                                            # gene number
Nk = 5 * 3                                        # eQTL number
Ns = 1                                            # sparse ratio
sigma2 = 0.01                                     # sigma2
set.seed(seed)
data = randomFSSEMdata(n = N, p = Ng, k = Nk, sparse = Ns, df = 0.3, sigma2 = sigma2,
                       u = 5, type = "DG", nhub = 1, dag = TRUE)
## If we assume that different condition has different genetics perturbations (eQTLs)
## data$Data$X = list(data$Data$X, data$Data$X)
gamma = cv.multiRegression(data$Data$X, data$Data$Y, data$Data$Sk, ngamma = 20, nfold = 5,
                           N, Ng, Nk)
fit   = multiRegression(data$Data$X, data$Data$Y, data$Data$Sk, gamma, N, Ng, Nk,
                      trans = FALSE)
}
