% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LocalPoSpKnucF.R
\name{LocalPoSpKnucF}
\alias{LocalPoSpKnucF}
\title{Local Position Specific k Nucleotide Frequency}
\usage{
LocalPoSpKnucF(
  seqs,
  k = 2,
  label = c(),
  outFormat = "mat",
  outputFileDist = ""
)
}
\arguments{
\item{seqs}{is a FASTA file containing nucleotide sequences. The sequences start
with '>'. Also, seqs could be a string vector. Each element of the vector is a nucleotide sequence.}

\item{k}{is a numeric value which holds the value of k in the k-mers.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}

\item{outFormat}{(output format) can take two values: 'mat'(matrix) and 'txt'. The default value is 'mat'.}

\item{outputFileDist}{shows the path and name of the 'txt' output file.}
}
\value{
The output depends on the outFormat parameter which can be either 'mat' or 'txt'. If outFormat is 'mat', the function returns a feature
matrix for sequences with the same length such that the number of columns is (sequence length-k+1)
and the number of rows is equal to the number of sequences. It is usable for machine learning purposes.
If the outFormat is 'txt', the output is written to a tab-delimited file.
}
\description{
For each sequence, this function creates a feature vector denoted as
(f1,f2, f3, …, fN), where fi = freq(i'th k-mer of the sequence) / i.
It should be applied to sequences with the same length.
}
\examples{

dir = tempdir()
LNCSeqsADR<-system.file("extdata/",package="ftrCOOL")
LNC50Nuc<-as.vector(read.csv(paste0(LNCSeqsADR,"/LNC50Nuc.csv"))[,2])
mat<-LocalPoSpKnucF(seqs = LNC50Nuc, k=2,outFormat="mat")

ad<-paste0(dir,"/LocalPoSpKnucF.txt")
fileLNC<-system.file("extdata/Athaliana_LNCRNA.fa",package="ftrCOOL")
LocalPoSpKnucF(seqs = fileLNC,k=1,outFormat="txt"
,outputFileDist=ad)
}
