% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NUC2Binary_DNA.R
\name{NUC2Binary_DNA}
\alias{NUC2Binary_DNA}
\title{Nucleotide To Binary (NUC2Binary_DNA)}
\usage{
NUC2Binary_DNA(
  seqs,
  binaryType = "strBin",
  label = c(),
  outFormat = "mat",
  outputFileDist = ""
)
}
\arguments{
\item{seqs}{is a FASTA file containing nucleotide sequences. The sequences start
with '>'. Also, seqs could be a string vector. Each element of the vector is a nucleotide sequence.}

\item{binaryType}{It can take any of the following values: ('strBin','logicBin','numBin').
'strBin'(String binary): each nucleotide is represented by a string containing 4 characters(0-1). A = "0001" , C = "0010" , G = "0100" , T = "1000"
'logicBin'(logical value): Each nucleotide is represented by a vector containing 4 logical entries. A = c(F,F,F,T) , ... , T = c(T,F,F,F)
'numBin' (numeric bin): Each nucleotide is represented by a numeric (i.e., integer) vector containing 4 numerals. A = c(0,0,0,1) , ... , T = c(1,0,0,0)}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}

\item{outFormat}{(output format) can take two values: 'mat'(matrix) and 'txt'. The default value is 'mat'.}

\item{outputFileDist}{shows the path and name of the 'txt' output file.}
}
\value{
The output is different depending on the outFormat parameter ('mat' or 'txt').
If outFormat is set to 'mat', it returns a feature matrix for sequences with the same lengths.
The number of rows is equal to the number of sequences and if binaryType is 'strBin', the number of columns is the length of the sequences.
Otherwise, it is equal to (length of the sequences)*4.
If outFormat is 'txt', all binary values will be written to a 'txt' file. Each line in the file shows the binary format of a sequence.
}
\description{
This function transforms a nucleotide to a binary format.
The type of the binary format is determined by the binaryType parameter.
For details about each format, please refer to the description of the binaryType parameter.
}
\note{
This function is provided for sequences with the same lengths.
Users can use 'txt' option in outFormat parameter for sequences with different lengths.
Warning: If outFormat is set to 'mat' for sequences with different lengths, it returns an error.
Also, when output format is 'txt', label information is not shown in the text file.
It is noteworthy that 'txt' format is not usable for machine learning purposes.
}
\examples{

dir = tempdir()
LNCSeqsADR<-system.file("extdata/",package="ftrCOOL")
LNC50Nuc<-as.vector(read.csv(paste0(LNCSeqsADR,"/LNC50Nuc.csv"))[,2])
mat<-NUC2Binary_DNA(seqs = LNC50Nuc,outFormat="mat")

ad<-paste0(dir,"/NUC2Binary.txt")
fileLNC<-system.file("extdata/Athaliana_LNCRNA.fa",package="ftrCOOL")
NUC2Binary_DNA(seqs = fileLNC,binaryType="strBin",outFormat="txt",outputFileDist=ad)
}
