% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/funDataMethods.R
\name{extractObs}
\alias{extractObs}
\title{Extract observations of functional data}
\usage{
extractObs(object, obs = 1:nObs(object), argvals = getArgvals(object))
}
\arguments{
\item{object}{An object of class \code{funData}, \code{irregFunData} or
\code{multiFunData}.}

\item{obs}{A numeric vector, giving the indices of the observations to
extract (default: all obervations).}

\item{argvals}{The part of the domain to be extracted (default: the whole domain
  \code{object}@\code{argvals}). Must be a list or a numeric vector (only for one-dimensional
  domains, see also the definition of \code{\linkS4class{funData}},
  \code{\linkS4class{multiFunData}}).}
}
\value{
An object of class \code{funData}, \code{irregFunData} or \code{multiFunData} containing
  the desired observations.
}
\description{
This function extracts one or more observations and/or observations on a part
of the domain from a \code{funData}, \code{irregFunData} or
\code{multiFunData} object.
}
\details{
In case of an \code{irregFunData} object, some functions may not have
observation points in the given part of the domain. In this case, the
functions are removed from the extracted dataset and a warning is thrown.
}
\section{Warning}{
 The function is currently implemented only for functional
  data with up to three-dimensional domains.
}
\examples{
# Univariate - one-dimensional domain
object1 <- funData(argvals = 1:5, X = rbind(1:5, 6:10))
extractObs(object1, obs = 1)
extractObs(object1, argvals = 1:3)
extractObs(object1, argvals = list(1:3)) # the same as the statement before

# Univariate - two-dimensional domains
object2 <- funData(argvals = list(1:5, 1:6), X = array(1:60, dim = c(2, 5, 6)))
extractObs(object2, obs = 1)
extractObs(object2, argvals = list(1:3, c(2,4,6))) # argvals must be supplied as list

# Univariate - irregular
irregObject <- irregFunData(argvals = list(1:5, 2:4), X = list(2:6, 3:5))
extractObs(irregObject, obs = 2)
extractObs(irregObject, argvals = 1:3)
extractObs(irregObject, argvals = c(1,5)) # throws a warning, as second function has no observations

# Multivariate
multiObject <- multiFunData(object1, object2)
extractObs(multiObject, obs = 2)
extractObs(multiObject, argvals = list(1:3, list(1:3, c(2,4,6))))
}
\seealso{
\code{\linkS4class{funData}}, \code{\linkS4class{irregFunData}}, \code{\linkS4class{multiFunData}}
}

