% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FRTM.R
\name{mFPCA}
\alias{mFPCA}
\title{Mixed Functional Principal Component Analysis (mFPCA)}
\usage{
mFPCA(x_fd, h_fd = NULL, k_weights = "equal", ncom = "ptv", par_ncom = 0.9)
}
\arguments{
\item{x_fd}{An object of class fd corresponding to the registered functions.}

\item{h_fd}{An object of class fd corresponding to the warping functions.}

\item{k_weights}{The vector of the four constants in the inner product computation. If "equal", the  choice of Centofanti et al. (2024) is used.}

\item{ncom}{It is the way to select the number of principal components. If "ptv", it is selected considering the  percentage of the total variability explained.
If "kaiserrule", it is  selected considering the Kaiser rule. The number of principal components may be indicated directly as an integer as well.}

\item{par_ncom}{If \code{ncom="ptv"}, the threshold for the percentage of the total variability explained. If \code{ncom="kaiserrule"}, the threshold for the Kaiser rule. Otherwise, this parameter is not considered.}
}
\value{
A list containing the following arguments:

\code{eigfun_fd} A List of functions corresponding to the functional part of the principal components.

\code{eigvect_sc} A matrix corresponding to the scalar part of the principal components.

\code{scores} Scores corresponding to \code{x_fd} and \code{h_fd}.

\code{values} Eigenvalues corresponding to the selected principal components.

\code{varprop} Variance proportion explained by each principal component.

\code{k_weights} The vector of the four constants in the inner product computation.

\code{x_fd_list} A List of two elements: the list of the registered functions and the list of the centered log-ratio transformation of
the first derivatives of the normalized warping functions.

\code{sc_mat} Two column matrix corresponding to the scalar part of the observations used.

\code{mean_fd_list} Mean functions of the  functional part.

\code{mean_sc_mat}  Means  of the  scalar part.

\code{sd_fd_list} The standard deviation of the functional part.

\code{sd_sc_mat} Standard deviations  of the scalar part.

\code{h_fd} An object of class fd corresponding to the warping functions.

\code{x_fd} An object of class fd corresponding to the registered functions.
\code{ind_var} Additional parameter  used in \code{FRTM_PhaseI}.
}
\description{
This function implements the mFPCA.
}
\examples{
library(funcharts)

data <- simulate_data_FRTM(n_obs = 100)
X <- sapply(1:100, function(ii)
  data$x_true[[ii]])
x_fd <-
  fda::smooth.basis(y = X,
                    argvals =  data$grid,
                    fda::create.bspline.basis(c(0, 1), 30))$fd
H <- sapply(1:100, function(ii)
  data$h[[ii]])
h_fd <-
  fda::smooth.basis(y = H,
                    argvals =  data$grid,
                    fda::create.bspline.basis(c(0, 1), 30))$fd
mod_mFPCA <- mFPCA(x_fd, h_fd, ncom = "ptv", par_ncom = 0.95)
plot(mod_mFPCA)

}
\references{
Centofanti, F., A. Lepore, M. Kulahci, and M. P. Spooner (2024).
Real-time monitoring of functional data. \emph{Journal of Quality Technology}, 57(2):135--152,
doi:https://doi.org/10.1080/00224065.2024.2430978.
}
