% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{CedarCreek.2004.2006.dat}
\alias{CedarCreek.2004.2006.dat}
\title{Data of Cedar Creek experiment for the years 2004, 2005 and 2006}
\format{A data.frame. Each row corresponds to an \emph{species assemblage},
  that is here a plot.
  The different columns of the data.frame are:
\describe{
  \item{Plot:}{ numero of the plot. Each assemblage must have
        a specific elemental composition,
        different from this of other assemblages.
        This first column is the \emph{identity} of assemblages.}
  \item{Achmi, Agrsm, Amocan, Andge, Asctu, Elyca, Koecr, Lesca, Liaas,
        Luppe, Monfi, Panvi, Petpu, Poapr, Schsc, Sornu:}{ abbreviated
        names of species.
        The set of species makes up an ecosystem.
        Each species is informed by \code{1} if it belongs to the assemblage,
        and by \code{0} if it does not belong to the assemblage.
        The whole is the \emph{matrix of occurrence}
        of different \emph{components} that belong to, and thus make up,
        the \emph{interactive system} under consideration.}
  \item{y2004, y2005, y2006:}{ "unsorted biomass" of plots,
        \emph{i.e.} species assemblages, harvested in August 2004,
        July 2005 and June 2006. Each harvest is a
        \emph{collective, systemic performance}
        of species assemblages. The performances can be treated separately,
        or collectively.}
}}
\source{
\url{https://www.cedarcreek.umn.edu/research/data/dataset?ple120}
}
\usage{
CedarCreek.2004.2006.dat
}
\description{
Data from Cedar Creek Ecosystem Science Reserve.
The data used here as an example come from the \emph{e120} experiment,
more commonly known as \emph{BioDIV} experiment.
We have selected the "unsorted biomass" of the harvests
of years 2004, 2005 and 2006, and the plots planted without any oak.
}
\details{
The Cedar Creek Ecosystem Science Reserve work was supported
 by grants from the US National Science Foundation Long-Term Ecological
 Research Program (LTER) including DEB-0620652 and DEB-1234162.
 Further support was provided by the Cedar Creek Ecosystem Science
 Reserve and the University of Minnesota.
}
\keyword{datasets}
