% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fexport.R
\name{ftest_read}
\alias{ftest_read}
\title{Read the significance of different variables
 of a functional clustering}
\usage{
ftest_read(filename,
           opt.var = c("components", "assemblages", "performances") )
}
\arguments{
\item{filename}{a string, used as radical for naming the file
\code{"filename.components.csv"}, \code{"filemane.assemblages.csv"}
or \code{"filemane.performances.csv"}
according to the dimensions of matrices.}

\item{opt.var}{a string, specifying the last part of the file-name.
\code{opt} can only be equal to
\code{"components"}, \code{"assemblages"} or \code{"performances"}.}
}
\value{
a list of matrices,
each containing the results for a clustering index.
}
\description{
Read a file of results obtained by
a test of significance of functional clustering.
}
\details{
The functions
  \code{ftest_components}, \code{ftest_assemblages},
  \code{ftest_performances}, \code{fboot_assemblages}
  and \code{fboot_performances}.
  generate a list containing a matrix by clustering index
  ("Czekanowski_Dice", "Folkes_Mallows", "Jaccard", "Kulczynski",
  "Precision", "Rand", "Recall", "Rogers_Tanimoto", "Russel_Rao",
  "Sokal_Sneath1" and "Sokal_Sneath2" index).
  Only their dimensions change according the used functions.
  Consequently, a same function is used for recording and reading
  the results of both the test-functions.
}
\examples{

# save "res" in the files "myRecord.*" then read it again.

filename <- tempfile(pattern = "myRecord", tmpdir = tempdir())

ftest_write(fres  = CedarCreek.2004.2006.res,
            rtest = CedarCreek.2004.2006.test.components,
            filename = filename,
            opt.var  = "components")

rtest <- ftest_read(filename = filename, opt.var = "components")

all.equal(rtest, CedarCreek.2004.2006.test.components)


}
