% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fclust.R
\name{plot_prediction_LOO}
\alias{plot_prediction_LOO}
\title{Plot Simulated and Predicted \emph{vs} Observed performances}
\usage{
plot_prediction_LOO(Fx, Fy, Fz,
                    assMotif = rep(1, length(Fx)),
                    xylab     = c("Observed performance",
                                  "Modelled performance"),
                    xylim     = range(Fx),
                    figs = rep(fsymbols()[1], length(Fx)),
                    cols = rep(fcolours()[1], length(Fx)),
                    nbcl      = 1,
                    main      = "",
                    opt.mean  = "amean",
                    pvalue    = fpvalue())
}
\arguments{
\item{Fx, Fy, Fz}{three numeric vectors of \code{length(Fx)}.
The first vector contains reference, observed assemblage performances.
The second vector contains assemblage performances
modelled by component clustering.
The third vector contains assemblage performances
predicted by cross-validation.}

\item{assMotif}{an integer vector.
The vector contains the labels of each assemblages.
The labels are only used to plot the assemblage performances
that share a same assembly motif
with a same symbol and color.
If it is omitted, all points are plotted using a same symbol and color.
The default symbol and color is \code{"red circle"}.}

\item{xylab}{a vector of two strings.
The strings are the labels of the axis.}

\item{xylim}{a vector of two numerics.
The numerics are extrem values of the two axis.}

\item{figs, cols}{two integer vectors of \code{length(Fx)}.
They contain the symbols and colours specific to each assembly motif
recorded in \code{assMotif}.}

\item{nbcl}{an integer.
The integer indicates the number of clusters of components.
The theoretical number \code{m} of assembly motif
is \code{m = 2^nbcl - 1}.
The number of clusters of components is only used
as information written on the graph.}

\item{main}{a string. The string is used as graph title.}

\item{opt.mean}{a character equals to \code{"amean"} or \code{"gmean"}.
Switch to arithmetic formula if \code{opt.mean = "amean"}.
Switch to geometric formula if \code{opt.mean = "gmean"}.}

\item{pvalue}{a probability,
used as threshold
in the variance analysis. Then \code{pvalue} must be
higher than \code{0} and lower than \code{1}.
Groups significantly different
(at a p-value < \code{pvalue}) are then indicated by differents letters
on the right of boxplots.}
}
\value{
Nothing. It is a procedure.
}
\description{
Take three vectors
corresponding to assemblage performances modelled,
predicted by cross-validation and observed,
then plot modelled assemblage performances
\emph{versus} observed assemblage performances.
The error induced by the cross-validation
is drawn as a line linking modelled and predicted assemblage performances.
}
\details{
All options are default values. If all options are omitted,
the function plot \code{Fy vs Fx},
in red circle with \code{"Simuled performances"}
\emph{vs} \code{"Observed performances"}
as axis labels.\cr

The two dashed blue lines are \code{mean(Fy)} and \code{mean(Fx)}.
}
\keyword{internal}
