% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{test_dependent_R2}
\alias{test_dependent_R2}
\title{Test for the dependence of two Pearson' R2}
\usage{
test_dependent_R2(v1, v2, v3, n = length(v1))
}
\arguments{
\item{v1, v2, v3}{three numeric vectors of \code{n = length(v1)},
or three coefficients of determination. If inputs are three coefficients
 of determination, vector length \code{n} must be specified.}

\item{n}{the length of vectors. \code{n} must be specified
if the inputs are three coefficients of determination.}
}
\value{
Return a p-value.
}
\description{
Test for the dependence of two R2.
}
\details{
Be careful, the three vectors \code{v1, v2, v3}
are not symmetrical.
The function compares R2 obtained by the models \code{v1 ~ v3} and
 \code{v2 ~ v3}.
}
\seealso{
\code{\link{test_dependent_R2mse}},
         \code{\link{pvalue_dependent_R2mse}}
}
\keyword{internal}
