% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Best.R
\name{Best}
\alias{Best}
\title{Find the best value in a vector.}
\usage{
Best(.x, .f)
}
\arguments{
\item{.x}{A vector.}

\item{.f}{A binary predicate function.}
}
\value{
The best value in that vector, as determined by the binary predicate function.
}
\description{
\code{Best()} takes a vector \code{.x} and a binary predicate function
\code{.f} and returns the result of \code{.f} reduced over \code{.x}.
}
\examples{
# Simulate the behavior of max with numerics
Best(1:10, function(x, y) return(x > y))
# Simulate the behavior of min with numerics
Best(1:10, function(x, y) return(x < y))
# This comparison function prefers values that begin with l
Best(letters, function(x, y) return(x[1] == "l"))
}

