% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funspace.R
\name{funspace}
\alias{funspace}
\title{Functional space}
\usage{
funspace(
  x,
  PCs = c(1, 2),
  group.vec = NULL,
  fixed.bw = TRUE,
  n_divisions = 100,
  trait_ranges = NULL,
  threshold = 0.999
)
}
\arguments{
\item{x}{Data to create the functional space. It can be either a PCA object obtained using the \code{princomp} function, or a matrix or data frame with two columns (representing two dimensions which can be traits or ordination scores).}

\item{PCs}{A vector specifying the Principal Components to be considered (e.g. choosing \code{PCs = c(1,2)} would lead to to consider the first and the second principal components). Only applies if \code{x} contains a PCA. Defaults to \code{c(1, 2)}, which selects the first two principal components.}

\item{group.vec}{An object of class factor specifying the levels of the grouping variable.}

\item{fixed.bw}{Logical indicating whether the same bandwidth that is used in the kde estimation for the whole dataset should also be used for the kde estimation of individual groups of observations (\code{fixed.bw = T}), or if a different bandwidth has to be estimated for each group ((\code{fixed.bw = F})). Defaults to TRUE, which makes the most extreme quantiles of the individual groups to coincide with those of the global distribution, and allows for more meaningful comparisons of the amount of functional space occupied by groups (functional richness).}

\item{n_divisions}{The number of equal-length parts in which each principal component  should be divided to calculate the grid in which calculations are based. Higher values of n_divisions will result in larger computation times, but also more smooth graphics. Defaults to 100.}

\item{trait_ranges}{A list indicating the range of values that will be considered in the calculations for each of the considered PCA components. The list should contain the range (minimum and maximum) of  values that will be considered. Each element of the list corresponds with one PCA component. The order of the components must be the same as the order provided in \code{PCs}. Defaults to    NULL, in which case ranges are automatically calculated to ensure the functional space considered is sufficiently large to encompass the whole TPD function.}

\item{threshold}{The probability threshold to consider to estimate the TPD function. TPD functions are positive across the whole trait space; \code{threshold} defines boundaries beyond which the TPD function is set to 0 (see Carmona et al. 2016; 2019 for more information). Defaults to 0.999.}
}
\value{
\code{funspace} The function returns an object of class \code{funspace} containing characteristics of the functional space and the trait probability distributions. The object includes estimations of functional richness and functional divergence for all observations taken together (global) and for each individual group (if groups are provided). The \code{funspace} class has specific methods exists for the generic functions \code{plot} and \code{summary}.
}
\description{
Defines the functional structure of a set of species
}
\details{
The functional structure of a set of organisms refers to how these organisms are distributed within a functional space (a space defined by traits). Functional structure can be expressed in probabilistic terms using trait probability density functions (TPD). TPD functions reflect how densely the organisms occupy the different parts of the functional space, and are implemented in the package \code{TPD} (Carmona et al. 2019).

\code{funspace} allows the user to define functional structure in a two-dimensional functional space created using a PCA, other ordination methods, or raw traits. The function automatically estimates the probability of occurrence of trait combinations within the space using kernel density estimation with unconstrained bandwidth using the functions from the \code{ks} R package  (Duong, 2007). Contour lines can be drawn at any quantile of the probability distribution. Colored areas, corresponding to the target quantiles, visually summarize the probability of occurrence of certain trait combinations within the trait space.
}
\examples{

# 1. Plotting a space based on a PCA
x <- princomp(GSPFF)
funtest <- funspace(x = x, PCs = c(1, 2), threshold = 0.95)
summary(funtest)
plot(funtest, type = "global")

#2. To include groups, let's consider two major families.
# We will use two raw traits, ph and sla:
selFam <- c("Pinaceae", "Fabaceae")
selRows <- which(GSPFF_tax$family \%in\% selFam)
GSPFF_subset <- GSPFF[selRows, c("ph", "sla")]
tax_subset <- droplevels(GSPFF_tax[selRows, ])
funtest <- funspace(x = GSPFF_subset, threshold = 0.95, group.vec = tax_subset$family)
summary(funtest)
plot(funtest, type = "global")
plot(funtest, type = "groups", axis.title.x = "Plant height",
   axis.title.y = "Specific leaf area",
   quant.plot = TRUE, pnt = TRUE, pnt.cex = 0.5,
   pnt.col = rgb(0, 1, 1, alpha = 0.2))

}
\references{
CP Carmona, F de Bello, NWH Mason, J Leps (2019). Trait Probability Density (TPD): measuring functional diversity across scales based on trait probability density with R. Ecology e02876.
T Duong, T., (2007). ks: Kernel Density Estimation and Kernel Discriminant Analysis for Multivariate Data in R. J. Stat. Softw. 21(7), 1-16.
}
