% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register_config_file.R
\name{register_all_to_config}
\alias{register_all_to_config}
\title{Include all existing package files in the config file}
\usage{
register_all_to_config(pkg = ".")
}
\arguments{
\item{pkg}{Path to the package from which to add file to configuration file}
}
\value{
Invisible path to 'fusen' configuration file
}
\description{
Helps transition from non-fusen packages or made with earlier version
}
\examples{
\dontrun{
# Usually run this one inside the current project
# Note: running this will write "dev/config_fusen.yaml" in your working directory
register_all_to_config()
}

# Or you can try on the reproducible example
dummypackage <- tempfile("register")
dir.create(dummypackage)

# {fusen} steps
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
dev_file <- suppressMessages(add_flat_template(pkg = dummypackage, overwrite = TRUE, open = FALSE))
flat_file <- dev_file[grepl("flat_", dev_file)]
# Inflate once
usethis::with_project(dummypackage, {
  suppressMessages(
    inflate(
      pkg = dummypackage, flat_file = flat_file,
      vignette_name = "Get started", check = FALSE,
      open_vignette = FALSE
    )
  )
  out_path <- register_all_to_config(dummypackage)

  # Look at the output
  yaml::read_yaml(out_path)
})
}
\seealso{
\code{\link[=check_not_registered_files]{check_not_registered_files()}} for the list of files not already associated with a flat file in the config file,
}
