% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fusionCustomLegend.R
\name{fusionCustomLegend}
\alias{fusionCustomLegend}
\title{Customing FusionCharts legend}
\usage{
fusionCustomLegend(
  fusionPlot,
  plotHighlightEffect = FALSE,
  plotHighlightEffectColor = "#7f7f7f",
  plotHighlightEffectAlpha = "60",
  drawCustomLegendIcon = TRUE,
  legendIconBgColor = NULL,
  legendIconAlpha = "100",
  legendIconBgAlpha = "100",
  legendIconBorderColor = "#123456",
  legendIconBorderThickness = "0",
  legendIconSides = "1",
  legendIconStartAngle = "45",
  legendScrollBgColor = "#5A5A5A",
  legendBgColor = "#CCCCCC",
  legendBgAlpha = "0",
  legendBorderColor = "#666666",
  legendBorderThickness = "0",
  legendBorderAlpha = "40",
  legendCaptionAlignment = c("center", "left", "right"),
  legendShadow = FALSE,
  legendItemFontBold = FALSE,
  legendItemFont = "Arial",
  legendItemFontSize = "14",
  legendItemFontColor = "#5A5A5A",
  legendItemHover = FALSE,
  legendItemHoverFontColor = "#cccccc"
)
}
\arguments{
\item{fusionPlot}{fusionPlot object got by \code{fusionPlot()}}

\item{plotHighlightEffect}{Enable highlighting of corresponding data series after hover over a legend text}

\item{plotHighlightEffectColor}{Specify the color}

\item{plotHighlightEffectAlpha}{Specify the opacity}

\item{drawCustomLegendIcon}{Enable drawing of a custom legend icon}

\item{legendIconBgColor}{Specify the hex color code for the background of the legend icon}

\item{legendIconAlpha}{Set the legend icon transparency (0 to 100)}

\item{legendIconBgAlpha}{Set the legend icon background transparency}

\item{legendIconBorderColor}{Specify the hex color code for the border of the legend icon}

\item{legendIconBorderThickness}{Set the thickness of the legend icon border}

\item{legendIconSides}{Set the number of sides for the legend icon}

\item{legendIconStartAngle}{Set the starting angle for drawing the legend icon}

\item{legendScrollBgColor}{Specify the background color of the scroll bar}

\item{legendBgColor}{Specify the background color for the legend}

\item{legendBgAlpha}{Specify the background transparency for the legend}

\item{legendBorderColor}{Specify the border color for the legend}

\item{legendBorderThickness}{Specify the border thickness for the legend}

\item{legendBorderAlpha}{Specify the border transparency for the legend}

\item{legendCaptionAlignment}{Specify the horizontal alignment of the legend caption}

\item{legendShadow}{Enable the legend shadow}

\item{legendItemFontBold}{Display legend keys in bold}

\item{legendItemFont}{Specify the legend item font}

\item{legendItemFontSize}{Specify the legend item font size (0 to 72)}

\item{legendItemFontColor}{Specify the legend item font color}

\item{legendItemHover}{Enable hover effect to legend item}

\item{legendItemHoverFontColor}{Specify the legend item font color on hover}
}
\description{
\url{https://www.fusioncharts.com/dev/chart-guide/chart-configurations/legend}
}
\examples{
library(fusionchartsR)
df <- data.frame(label = c("Venezuela", "Saudi", "Canada", "Russia"), value = c(290, 260,180, 115))
df \%>\%
fusionPlot(x = "label", y = "value", type = "doughnut2d") \%>\%
fusionCustomLegend(plotHighlightEffect = TRUE) \%>\%
fusionTheme(theme = "fusion")

}
