% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future_eapply.R, R/future_lapply.R,
%   R/future_replicate.R, R/future_sapply.R, R/future_tapply.R,
%   R/future_vapply.R
\name{future_eapply}
\alias{future_eapply}
\alias{future_lapply}
\alias{future_replicate}
\alias{future_sapply}
\alias{future_tapply}
\alias{future_vapply}
\title{Apply a Function over a List or Vector via Futures}
\usage{
future_eapply(env, FUN, ..., all.names = FALSE, USE.NAMES = TRUE)

future_lapply(X, FUN, ..., future.globals = TRUE,
  future.packages = NULL, future.seed = FALSE, future.lazy = FALSE,
  future.scheduling = 1, future.chunk.size = NULL)

future_replicate(n, expr, simplify = "array", future.seed = TRUE, ...)

future_sapply(X, FUN, ..., simplify = TRUE, USE.NAMES = TRUE)

future_tapply(X, INDEX, FUN = NULL, ..., default = NA,
  simplify = TRUE)

future_vapply(X, FUN, FUN.VALUE, ..., USE.NAMES = TRUE)
}
\arguments{
\item{env}{An \R environment.}

\item{FUN}{A function taking at least one argument.}

\item{all.names}{If \code{TRUE}, the function will also be applied to variables
that start with a period (\code{.}), otherwise not.
See \code{\link[base:eapply]{base::eapply()}} for details.}

\item{USE.NAMES}{See \code{\link[base:sapply]{base::sapply()}}.}

\item{X}{A vector-like object to iterate over.}

\item{future.globals}{A logical, a character vector, or a named list for
controlling how globals are handled. For details, see below section.}

\item{future.packages}{(optional) a character vector specifying packages
to be attached in the R environment evaluating the future.}

\item{future.seed}{A logical or an integer (of length one or seven),
or a list of \code{length(X)} with pre-generated random seeds.
For details, see below section.}

\item{future.lazy}{Specifies whether the futures should be resolved
lazily or eagerly (default).}

\item{future.scheduling}{Average number of futures ("chunks") per worker.
If \code{0.0}, then a single future is used to process all elements
of \code{X}.
If \code{1.0} or \code{TRUE}, then one future per worker is used.
If \code{2.0}, then each worker will process two futures
(if there are enough elements in \code{X}).
If \code{Inf} or \code{FALSE}, then one future per element of
\code{X} is used.
Only used if \code{future.chunk.size} is \code{NULL}.}

\item{future.chunk.size}{The average number of elements per future ("chunk").
If \code{NULL}, then argument \code{future.scheduling} is used.}

\item{n}{The number of replicates.}

\item{expr}{An \R expression to evaluate repeatedly.}

\item{simplify}{See \code{\link[base:sapply]{base::sapply()}} and \code{\link[base:tapply]{base::tapply()}}, respectively.}

\item{INDEX}{A list of one or more factors, each of same length as \code{X}.
The elements are coerced to factors by \code{as.factor()}.
See also \code{\link[base:tapply]{base::tapply()}}.}

\item{default}{See \code{\link[base:tapply]{base::tapply()}}.}

\item{FUN.VALUE}{A template for the required return value from
each \code{FUN(X[ii], ...)}.
Types may be promoted to a higher type within the ordering
logical < integer < double < complex, but not demoted.
See \code{\link[base:vapply]{base::vapply()}} for details.}

\item{\ldots}{(optional) Additional arguments passed to \code{FUN()}.
For \code{future_*apply()} functions and \code{replicate(), any}future.*\code{arguments part of \ldots are passed on to}future_lapply()` used internally.}
}
\value{
A named (unless \code{USE.NAMES = FALSE}) list.
See \code{\link[base:eapply]{base::eapply()}} for details.

For \code{future_lapply()}, a list with same length and names as \code{X}.
See \code{\link[base:lapply]{base::lapply()}} for details.

\code{future_replicate()} is a wrapper around \code{future_sapply()} and return
simplified object according to the \code{simplify} argument.
See \code{\link[base:replicate]{base::replicate()}} for details.
Since \code{future_replicate()} usually involves random number generation (RNG),
it uses \code{future.seed = TRUE} by default in order produce sound random
numbers regardless of future backend and number of background workers used.

For \code{future_sapply()}, a vector with same length and names as \code{X}.
See \code{\link[base:sapply]{base::sapply()}} for details.

\code{future_tapply()} returns an array with mode \code{"list"}, unless
\code{simplify = TRUE} (default) \emph{and} \code{FUN} returns a scalar, in which
case the mode of the array is the same as the returned scalars.
See \code{\link[base:tapply]{base::tapply()}} for details.

For \code{future_vapply()}, a vector with same length and names as \code{X}.
See \code{\link[base:vapply]{base::vapply()}} for details.
}
\description{
\code{future_lapply()} implements \code{\link[base:lapply]{base::lapply()}} using futures with perfect
replication of results, regardless of future backend used.
Analogously, this is true for all the other \code{future_nnn()} functions.
}
\section{Global variables}{

Argument \code{future.globals} may be used to control how globals
should be handled similarly how the \code{globals} argument is used with
\code{future()}.
Since all function calls use the same set of globals, this function can do
any gathering of globals upfront (once), which is more efficient than if
it would be done for each future independently.
If \code{TRUE}, \code{NULL} or not is specified (default), then globals
are automatically identified and gathered.
If a character vector of names is specified, then those globals are gathered.
If a named list, then those globals are used as is.
In all cases, \code{FUN} and any \code{...} arguments are automatically
passed as globals to each future created as they are always needed.
}

\section{Reproducible random number generation (RNG)}{

Unless \code{future.seed = FALSE}, this function guarantees to generate
the exact same sequence of random numbers \emph{given the same initial
seed / RNG state} - this regardless of type of futures, scheduling
("chunking") strategy, and number of workers.

RNG reproducibility is achieved by pregenerating the random seeds for all
iterations (over \code{X}) by using L'Ecuyer-CMRG RNG streams.  In each
iteration, these seeds are set before calling \code{FUN(X[[ii]], ...)}.
\emph{Note, for large \code{length(X)} this may introduce a large overhead.}
As input (\code{future.seed}), a fixed seed (integer) may be given, either
as a full L'Ecuyer-CMRG RNG seed (vector of 1+6 integers) or as a seed
generating such a full L'Ecuyer-CMRG seed.
If \code{future.seed = TRUE}, then \code{\link[base:Random]{.Random.seed}}
is returned if it holds a L'Ecuyer-CMRG RNG seed, otherwise one is created
randomly.
If \code{future.seed = NA}, a L'Ecuyer-CMRG RNG seed is randomly created.
If none of the function calls \code{FUN(X[[ii]], ...)} uses random number
generation, then \code{future.seed = FALSE} may be used.

In addition to the above, it is possible to specify a pre-generated
sequence of RNG seeds as a list such that
\code{length(future.seed) == length(X)} and where each element is an
integer seed vector that can be assigned to
\code{\link[base:Random]{.Random.seed}}.
Use this alternative with caution.
\strong{Note that \code{as.list(seq_along(X))} is \emph{not} a valid set of such
\code{.Random.seed} values.}

In all cases but \code{future.seed = FALSE}, the RNG state of the calling
R processes after this function returns is guaranteed to be
"forwarded one step" from the RNG state that was before the call and
in the same way regardless of \code{future.seed}, \code{future.scheduling}
and future strategy used.  This is done in order to guarantee that an \R
script calling \code{future_lapply()} multiple times should be numerically
reproducible given the same initial seed.
}

\examples{
## ---------------------------------------------------------
## lapply(), sapply(), tapply()
## ---------------------------------------------------------
x <- list(a = 1:10, beta = exp(-3:3), logic = c(TRUE, FALSE, FALSE, TRUE))
y0 <- lapply(x, FUN = quantile, probs = 1:3/4)
y1 <- future_lapply(x, FUN = quantile, probs = 1:3/4)
print(y1)
stopifnot(all.equal(y1, y0))

y0 <- sapply(x, FUN = quantile)
y1 <- future_sapply(x, FUN = quantile)
print(y1)
stopifnot(all.equal(y1, y0))

y0 <- vapply(x, FUN = quantile, FUN.VALUE = double(5L))
y1 <- future_vapply(x, FUN = quantile, FUN.VALUE = double(5L))
print(y1)
stopifnot(all.equal(y1, y0))


## ---------------------------------------------------------
## Parallel Random Number Generation
## ---------------------------------------------------------
\donttest{
## Regardless of the future plan, the number of workers, and
## where they are, the random numbers produced are identical

plan(multiprocess)
y1 <- future_lapply(1:5, FUN = rnorm, future.seed = 0xBEEF)
str(y1)

plan(sequential)
y2 <- future_lapply(1:5, FUN = rnorm, future.seed = 0xBEEF)
str(y2)

stopifnot(all.equal(y1, y2))
}
}
\author{
The implementations of \code{future_replicate()}, \code{future_sapply()}, and
\code{future_tapply()} are adopted from the source code of the corresponding
base \R functions, which are licensed under GPL (>= 2) with
'The R Core Team' as the copyright holder.
}
\keyword{iteration}
\keyword{manip}
\keyword{programming}
