% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchtools_custom.R
\name{batchtools_custom}
\alias{batchtools_custom}
\title{Batchtools futures for custom batchtools configuration}
\usage{
batchtools_custom(expr, envir = parent.frame(), substitute = TRUE,
  globals = TRUE, label = NULL, cluster.functions, resources = list(),
  workers = NULL, ...)
}
\arguments{
\item{expr}{The R expression to be evaluated}

\item{envir}{The environment in which global environment
should be located.}

\item{substitute}{Controls whether \code{expr} should be
\code{substitute()}:d or not.}

\item{globals}{(optional) a logical, a character vector, a named list, or
a \link[globals:Globals]{Globals} object.  If TRUE, globals are identified by code
inspection based on \code{expr} and \code{tweak} searching from environment
\code{envir}.  If FALSE, no globals are used.  If a character vector, then
globals are identified by lookup based their names \code{globals} searching
from environment \code{envir}.  If a named list or a Globals object, the
globals are used as is.}

\item{label}{(optional) Label of the future (where applicable, becomes the
job name for most job schedulers).}

\item{cluster.functions}{A
\link[batchtools:ClusterFunctions]{ClusterFunctions} object.}

\item{resources}{A named list passed to the batchtools template
(available as variable \code{resources}).}

\item{workers}{(optional) The maximum number of workers the batchtools
backend may use at any time.   Interactive and "local" backends can only
process one future at the time, whereas HPC backends where futures are
resolved via separate jobs on a scheduler, the default is to assume an
infinite number of workers.}

\item{\ldots}{Additional arguments passed to \code{\link[=BatchtoolsFuture]{BatchtoolsFuture()}}.}
}
\value{
An object of class \code{BatchtoolsFuture}.
}
\description{
Batchtools futures for custom batchtools configuration
}
