% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multicore.R
\name{multicore}
\alias{multicore}
\title{Create a multicore future whose value will be resolved asynchroneously in a forked parallel process}
\usage{
multicore(expr, envir = parent.frame(), substitute = TRUE, globals = TRUE,
  workers = availableCores(constraints = "multicore"), gc = FALSE,
  earlySignal = FALSE, ...)
}
\arguments{
\item{expr}{An R \link[base]{expression}.}

\item{envir}{The \link{environment} in which the evaluation
is done and from which globals are obtained.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{globals}{If TRUE, global objects are validated at the point
in time when the future is created (always before it is resolved),
that is, they identified and located.  If some globals fail to be
located, an informative error is generated.}

\item{workers}{The maximum number of multicore futures that can
be active at the same time before blocking.}

\item{gc}{If TRUE, the garbage collector run after the future
is resolved (in the process that evaluated the future).}

\item{earlySignal}{Specified whether conditions should be signaled as soon as possible or not.}

\item{\dots}{Not used.}
}
\value{
A \link{MulticoreFuture}
If \code{workers == 1}, then all processing using done in the
current/main R session and we therefore fall back to using
a eager future.  This is also the case whenever multicore
processing is not supported, e.g. on Windows.
}
\description{
A multicore future is a future that uses multicore evaluation,
which means that its \emph{value is computed and resolved in
parallel in another process}.
}
\details{
This function will block if all cores are occupied and
will be unblocked as soon as one of the already running
multicore futures is resolved.  For the total number of
cores available including the current/main R process, see
\code{\link{availableCores}()}.

Not all systems support multicore futures.  For instance,
it is not supported on Microsoft Windows.  Trying to create
multicore futures on non-supported systems will silently
fall back to using \link{eager} futures, which effectively
corresponds to a multicore future that can handle one parallel
process (the current one) before blocking.

The preferred way to create an multicore future is not to call
this function directly, but to register it via
\code{\link{plan}(multicore)} such that it becomes the default
mechanism for all futures.  After this \code{\link{future}()}
and \code{\link{\%<=\%}} will create \emph{multicore futures}.
}
\examples{
## Use multicore futures
plan(multicore)

## A global variable
a <- 0

## Create multicore future (explicitly)
f <- future({
  b <- 3
  c <- 2
  a * b * c
})

## A multicore future is evaluated in a separate forked
## process.  Changing the value of a global variable
## will not affect the result of the future.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)
}
\seealso{
For processing in multiple background R sessions, see
\link{multisession} futures.
For multicore processing with fallback to multisession where
the former is not supported, see \link{multiprocess} futures.

Use \code{\link{availableCores}()} to see the total number of
cores that are available for the current R session.
Use \code{\link{availableCores}("multicore") > 1L} to check
whether multicore futures are supported or not on the current
system.
}

