% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{nobs.mboottest}
\alias{nobs.mboottest}
\title{S3 method to obtain the effective number of observation used
in \code{mboottest()}}
\usage{
\method{nobs}{mboottest}(object, ...)
}
\arguments{
\item{object}{object of type mboottest}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A scalar containing the effective number of observations
used in \code{mboottest()}
}
\description{
S3 method to obtain the effective number of observation used
in \code{mboottest()}
}
\examples{
\dontrun{
requireNamespace("clubSandwich")
R <- clubSandwich::constrain_zero(2:3, coef(lm_fit))
wboottest <-
  mboottest(
    object = lm_fit,
    clustid = "group_id1",
    B = 999,
    R = R
  )
nobs(wboottest)
}

}
