/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.af.commons.Localizer;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.io.FileTransfer;
import org.af.commons.logging.LoggingSystem;
import org.af.commons.logging.widgets.DetailsDialog;
import org.af.commons.tools.OSTools;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.config.Configuration;
import org.mutoss.gui.AboutDialog;
import org.mutoss.gui.RControl;
import org.mutoss.gui.dialogs.NumberOfHypotheses;
import org.mutoss.gui.dialogs.TextFileViewer;
import org.mutoss.gui.graph.GraphView;
import org.mutoss.gui.graph.NetList;
import org.mutoss.gui.options.OptionsDialog;

public class MenuBarMGraph
extends JMenuBar
implements ActionListener {
    GraphView control;
    protected Localizer localizer = Localizer.getInstance();
    private static final Log logger = LogFactory.getLog(MenuBarMGraph.class);
    DecimalFormat format = new DecimalFormat("#.###");
    public String LATEX_BEGIN_DOCUMENT = "\\documentclass[11pt]{article}\n\\usepackage{tikz}\n\\usetikzlibrary{snakes,arrows,shapes}\n\\begin{document}\n";
    public String LATEX_END_DOCUMENT = "\\end{document}";

    public MenuBarMGraph(GraphView control) {
        this.control = control;
        JMenu menu = new JMenu("File");
        menu.add(this.makeMenuItem("New Graph", "new graph"));
        menu.add(this.makeMenuItem("Load Graph from file", "load graph"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("Save Graph to file", "save graph"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("Export Graph to PNG Image", "save graph image"));
        menu.add(this.makeMenuItem("Export Graph to LaTeX File", "save graph latex"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("Quit", "exit"));
        this.add(menu);
        menu = new JMenu("Example graphs");
        menu.add(this.makeMenuItem("Bonferroni-Holm Test", "bht"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("Parallel Gatekeeping with 4 Hypotheses", "pg"));
        menu.add(this.makeMenuItem("Improved Parallel Gatekeeping with 4 Hypotheses", "pgi"));
        menu.add(this.makeMenuItem("Example graph from Bretz et al. (2009)", "bretzEtAl"));
        menu.add(this.makeMenuItem("Example graph from Hommel et al. (2007)", "hommelEtAl"));
        this.add(menu);
        this.addExtrasMenu();
        this.addHelpMenu();
    }

    public void loadGraph(String string) {
        NetList nl = this.control.getNL();
        this.newGraph();
        RControl.getR().eval(nl.initialGraph + " <- " + string);
        nl.loadGraph();
        this.control.getMainFrame().validate();
    }

    public void newGraph() {
        this.control.stopTesting();
        this.control.getNL().reset();
    }

    public void showAbout() {
        new AboutDialog(this.control.getMainFrame());
    }

    public void showLog() {
        new DetailsDialog(LoggingSystem.getInstance().makeDetailsPanel());
    }

    public void reportError() {
        ErrorHandler.getInstance().makeErrDialog(this.localizer.getString("SGTK_MENU_EXTRAS_REPORT_ERROR"));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("new graph")) {
            this.newGraph();
        } else if (e.getActionCommand().equals("save graph")) {
            this.saveGraph();
        } else if (!e.getActionCommand().equals("save pdf")) {
            if (e.getActionCommand().equals("save graph image")) {
                this.saveGraphImage();
            } else if (e.getActionCommand().equals("save graph latex")) {
                this.exportLaTeXGraph();
            } else if (!e.getActionCommand().equals("save latex report")) {
                if (e.getActionCommand().equals("load graph")) {
                    this.loadGraph();
                } else if (e.getActionCommand().equals("bht")) {
                    new NumberOfHypotheses(this.control.getGraphGUI(), this, "createBonferroniHolmGraph");
                } else if (e.getActionCommand().equals("pg")) {
                    this.loadGraph("createGraphForParallelGatekeeping()");
                } else if (e.getActionCommand().equals("pgi")) {
                    this.loadGraph("createGraphForImprovedParallelGatekeeping()");
                } else if (e.getActionCommand().equals("bretzEtAl")) {
                    this.loadGraph("createGraphFromBretzEtAl()");
                } else if (e.getActionCommand().equals("hommelEtAl")) {
                    this.loadGraph("createGraphFromHommelEtAl()");
                } else if (e.getActionCommand().equals("showLog")) {
                    this.showLog();
                } else if (e.getActionCommand().equals("reportError")) {
                    this.reportError();
                } else if (e.getActionCommand().equals("exit")) {
                    this.control.getMainFrame().dispose();
                } else if (e.getActionCommand().equals("showAppHelp")) {
                    this.showFile("doc/gMCP.pdf");
                } else if (e.getActionCommand().equals("showParametric")) {
                    this.showFile("doc/correlated.pdf");
                } else if (e.getActionCommand().equals("showManual")) {
                    try {
                        Method main = Class.forName("java.awt.Desktop").getDeclaredMethod("getDesktop", new Class[0]);
                        Object obj = main.invoke((Object)new Object[0], new Object[0]);
                        Method second = obj.getClass().getDeclaredMethod("browse", URI.class);
                        second.invoke(obj, new URI("http://cran.at.r-project.org/web/packages/gMCP/gMCP.pdf"));
                    }
                    catch (Exception exc) {
                        logger.warn((Object)"No Desktop class in Java 5 or URI error.");
                        RControl.getR().eval("browseURL(\"http://cran.at.r-project.org/web/packages/gMCP/gMCP.pdf\")");
                    }
                } else if (e.getActionCommand().equals("showEpsDoc")) {
                    this.showFile("doc/EpsilonEdges.pdf");
                } else if (e.getActionCommand().equals("showNEWS")) {
                    new TextFileViewer(this.control.getMainFrame(), new File(RControl.getR().eval("system.file(\"NEWS\", package=\"gMCP\")").asRChar().getData()[0]));
                } else if (e.getActionCommand().equals("showAbout")) {
                    new AboutDialog(this.control.getMainFrame());
                } else if (e.getActionCommand().equals("showOptions")) {
                    new OptionsDialog(this.control.getMainFrame());
                }
            }
        }
    }

    public void showFile(String s) {
        File f = new File(RControl.getR().eval("system.file(\"" + s + "\", package=\"gMCP\")").asRChar().getData()[0]);
        if (OSTools.isWindows() && s.indexOf(46) == -1) {
            try {
                f = FileTransfer.copyFile((File)f, (File)new File(System.getProperty("java.io.tmpdir"), f.getName() + "TXT"));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.control.getMainFrame(), "Please open and read the following file:\n" + f.getAbsolutePath(), "Could not find appropriate viewer", 2);
            }
        }
        if (!f.exists()) {
            throw new RuntimeException("This is strange. The file \"" + s + "\" could not be found.");
        }
        try {
            Method main = Class.forName("java.awt.Desktop").getDeclaredMethod("getDesktop", new Class[0]);
            Object obj = main.invoke((Object)new Object[0], new Object[0]);
            Method second = obj.getClass().getDeclaredMethod("open", File.class);
            second.invoke(obj, f);
        }
        catch (Exception exc) {
            logger.warn((Object)"No Desktop class in Java 5 or URI error.");
            try {
                if (OSTools.isWindows()) {
                    Process p = Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler \"" + f.getAbsolutePath() + "\"");
                    p.waitFor();
                } else {
                    JOptionPane.showMessageDialog(this.control.getMainFrame(), "Please open and read the following file:\n" + f.getAbsolutePath(), "Could not find appropriate viewer", 2);
                }
            }
            catch (Exception e1) {
                logger.error((Object)e1.getMessage());
                e1.printStackTrace();
                JOptionPane.showMessageDialog(this.control.getMainFrame(), "Please open and read the following file:\n" + f.getAbsolutePath(), "Could not find appropriate viewer", 2);
            }
        }
    }

    public void writeLaTeX(String s) {
        File f;
        JFileChooser fc = new JFileChooser(Configuration.getInstance().getClassProperty(this.getClass(), "LaTeXDirectory"));
        fc.setDialogType(1);
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            f = fc.getSelectedFile();
            Configuration.getInstance().setClassProperty(this.getClass(), "LaTeXDirectory", f.getParent());
            if (!f.getName().toLowerCase().endsWith(".tex")) {
                f = new File(f.getAbsolutePath() + ".tex");
            }
        } else {
            return;
        }
        System.out.println("Export to: " + f.getAbsolutePath() + ".");
        try {
            FileWriter out = new FileWriter(f);
            out.write(this.LATEX_BEGIN_DOCUMENT);
            out.write(s);
            out.write(this.LATEX_END_DOCUMENT);
            out.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Saving LaTeX code to '" + f.getAbsolutePath() + "' failed: " + ex.getMessage(), "Saving failed.", 0);
        }
    }

    public void exportLaTeXGraph() {
        NetList nl = this.control.getNL();
        this.writeLaTeX(nl.getLaTeX());
    }

    private void saveGraphImage() {
        BufferedImage img = this.control.getNL().getImage();
        JFileChooser fc = new JFileChooser(Configuration.getInstance().getClassProperty(this.getClass(), "ImageDirectory"));
        fc.setFileSelectionMode(0);
        fc.setDialogType(1);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File f = fc.getSelectedFile();
            Configuration.getInstance().setClassProperty(this.getClass(), "ImageDirectory", f.getParent());
            if (!f.getName().toLowerCase().endsWith(".png")) {
                f = new File(f.getAbsolutePath() + ".png");
            }
            try {
                ImageIO.write((RenderedImage)img, "png", f);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Saving image to '" + f.getAbsolutePath() + "' failed: " + ex.getMessage(), "Saving failed.", 0);
            }
        }
    }

    private void loadGraph() {
        JFileChooser fc = new JFileChooser(Configuration.getInstance().getClassProperty(this.getClass(), "RObjDirectory"));
        fc.setFileSelectionMode(0);
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toLowerCase().endsWith(".xml");
            }

            public String getDescription() {
                return "XML files";
            }
        });
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            this.control.stopTesting();
            File f = fc.getSelectedFile();
            Configuration.getInstance().setClassProperty(this.getClass(), "RObjDirectory", f.getParent());
            try {
                String loadedGraph = RControl.getR().eval("load(file=\"" + f.getAbsolutePath() + "\")").asRChar().getData()[0];
                this.loadGraph(loadedGraph);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Loading graph from '" + f.getAbsolutePath() + "' failed: " + ex.getMessage(), "Saving failed.", 0);
            }
        }
        this.control.getMainFrame().validate();
    }

    private void saveGraph() {
        JFileChooser fc = new JFileChooser(Configuration.getInstance().getClassProperty(this.getClass(), "RObjDirectory"));
        fc.setFileSelectionMode(0);
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toLowerCase().endsWith(".xml");
            }

            public String getDescription() {
                return "XML files";
            }
        });
        fc.setDialogType(1);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File f = fc.getSelectedFile();
            Configuration.getInstance().setClassProperty(this.getClass(), "RObjDirectory", f.getParent());
            if (!f.getName().toLowerCase().endsWith(".xml")) {
                f = new File(f.getAbsolutePath() + ".xml");
            }
            try {
                String name = this.control.jtSaveName.getText();
                this.control.getNL().saveGraph(name, false);
                RControl.getR().eval("save(" + name + ", file=\"" + f.getAbsolutePath() + "\")");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Saving graph to '" + f.getAbsolutePath() + "' failed: " + ex.getMessage(), "Saving failed.", 0);
            }
        }
    }

    protected JMenuItem makeMenuItem(String text, String action) {
        return this.makeMenuItem(text, action, true);
    }

    protected JMenuItem makeMenuItem(String text, String action, boolean enabled) {
        JMenuItem item = new JMenuItem(text);
        item.setActionCommand(action);
        item.setEnabled(enabled);
        item.addActionListener(this);
        return item;
    }

    public void addExtrasMenu() {
        this.add(this.makeExtrasMenu());
    }

    public JMenu makeExtrasMenu() {
        JMenu menu = new JMenu(this.localizer.getString("SGTK_MENU_EXTRAS"));
        menu.add(this.makeMenuItem(this.localizer.getString("SGTK_MENU_EXTRAS_LOG"), "showLog"));
        menu.add(this.makeMenuItem(this.localizer.getString("SGTK_MENU_EXTRAS_OPTIONS"), "showOptions"));
        menu.add(this.makeMenuItem(this.localizer.getString("SGTK_MENU_EXTRAS_REPORT_ERROR"), "reportError"));
        return menu;
    }

    public void addHelpMenu() {
        this.add(this.makeHelpMenu());
    }

    private JMenu makeHelpMenu() {
        JMenu menu = new JMenu("Help");
        menu.add(this.makeMenuItem("About", "showAbout"));
        menu.add(this.makeMenuItem("Introduction to gMCP", "showAppHelp"));
        menu.add(this.makeMenuItem("Weighted parametric tests defined by graphs", "showParametric"));
        menu.add(this.makeMenuItem("gMCP R Online Reference manual", "showManual"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("Version Info / NEWS", "showNEWS"));
        return menu;
    }
}

