/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.dialogs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.MenuBarMGraph;
import org.af.gMCP.gui.RControl;

public class GraphSendToArchiveDialog
extends JDialog
implements ActionListener {
    JButton ok = new JButton("Load");
    CreateGraphGUI parent;
    JList jlMatrices;
    JList jlGraphs;
    String[] matrices;
    String[] graphs;
    JTextArea jtInfo = new JTextArea(12, 40);

    public GraphSendToArchiveDialog(CreateGraphGUI parent) {
        super(parent, "Select an R object to load", true);
        this.parent = parent;
        this.jtInfo.setEditable(false);
        this.jtInfo.setFont(new Font("Monospaced", 0, 10));
        this.matrices = RControl.getR().eval("gMCP:::getAllQuadraticMatrices()").asRChar().getData();
        this.graphs = RControl.getR().eval("gMCP:::getAllGraphs()").asRChar().getData();
        this.jlMatrices = new JList<String>(this.matrices);
        this.jlMatrices.setSelectionMode(0);
        this.jlGraphs = new JList<String>(this.graphs);
        this.jlGraphs.setSelectionMode(0);
        if (this.matrices.length == 1 && this.matrices[0].equals("No quadratic matrices found.")) {
            this.jlMatrices.setEnabled(false);
        }
        if (this.graphs.length == 1 && this.graphs[0].equals("No graphMCP objects found.")) {
            this.jlGraphs.setEnabled(false);
        }
        if (!this.jlGraphs.isEnabled() && !this.jlMatrices.isEnabled()) {
            JOptionPane.showMessageDialog(this, "No applicable R objects (quadratic matrices or graphMCP objects) found.", "No applicable R objects found.", 1);
            return;
        }
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        this.getContentPane().setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.getContentPane().add((Component)new JLabel("Graph objects"), cc.xy(2, row));
        this.getContentPane().add((Component)new JLabel("Quadratic matrices"), cc.xy(4, row));
        this.getContentPane().add((Component)new JLabel("Object info"), cc.xy(6, row));
        this.getContentPane().add((Component)new JScrollPane(this.jlGraphs), cc.xy(2, row += 2));
        this.getContentPane().add((Component)new JScrollPane(this.jlMatrices), cc.xy(4, row));
        this.getContentPane().add((Component)new JScrollPane(this.jtInfo), cc.xy(6, row));
        this.getContentPane().add((Component)this.ok, cc.xy(4, row += 2));
        this.ok.addActionListener(this);
        this.pack();
        this.setSize(760, 500);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.jlMatrices.getSelectedIndex() == -1 && this.jlGraphs.getSelectedIndex() == -1) {
            JOptionPane.showMessageDialog(this, "Please select an R object for loading from one of the lists.", "Please select an object.", 1);
            return;
        }
        String object = this.jlMatrices.getSelectedIndex() != -1 ? this.jlMatrices.getSelectedValue().toString() : this.jlGraphs.getSelectedValue().toString();
        ((MenuBarMGraph)this.parent.getJMenuBar()).loadGraph(object);
        Configuration.getInstance().getGeneralConfig().addGraph("R Object: " + object);
        this.dispose();
    }
}

