/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.config;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.af.commons.widgets.buttons.OKButtonPane;
import org.af.gMCP.config.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VersionComparator
extends JDialog
implements ActionListener {
    protected static Log logger = LogFactory.getLog(VersionComparator.class);
    static String onlineversion;

    public VersionComparator(String longMessage, String txt, String news, String version, String onlineVersion) {
        super((Frame)null, "New version available!");
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 10;
        c.ipady = 10;
        c.weightx = 1.0;
        c.weighty = 0.0;
        JTextArea jta1 = new JTextArea(txt);
        JTextArea jta2 = new JTextArea(longMessage);
        JTextArea jta3 = new JTextArea(news);
        jta3.setFont(new Font("Monospaced", 0, 8));
        if (txt.length() > 3) {
            this.getContentPane().add((Component)jta1, c);
            ++c.gridy;
        }
        this.getContentPane().add((Component)jta2, c);
        ++c.gridy;
        c.weighty = 1.0;
        JScrollPane js = new JScrollPane(jta3);
        this.getContentPane().add((Component)js, c);
        ++c.gridy;
        c.weighty = 0.0;
        OKButtonPane ok = new OKButtonPane();
        ok.addActionListener((ActionListener)this);
        this.getContentPane().add((Component)ok, c);
        this.getContentPane().setPreferredSize(new Dimension(800, 600));
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public static int compare(String v1, String v2) {
        int v;
        if (v1.equals(v2)) {
            return 0;
        }
        StringTokenizer st1 = new StringTokenizer(v1, ".-");
        StringTokenizer st2 = new StringTokenizer(v2, ".-");
        String tok1 = null;
        String tok2 = null;
        do {
            if (!st1.hasMoreTokens()) {
                return -1;
            }
            tok1 = st1.nextToken();
            if (!st2.hasMoreTokens()) {
                return 1;
            }
            tok2 = st2.nextToken();
            logger.debug((Object)("Comparing token " + tok1 + " vs. " + tok2 + "."));
        } while ((v = Integer.parseInt(tok1) - Integer.parseInt(tok2)) == 0);
        return v;
    }

    public static void getOnlineVersion() {
        try {
            if (Configuration.getInstance().getGeneralConfig().checkOnline()) {
                String line;
                String version = Configuration.getInstance().getGeneralConfig().getVersionNumber();
                String rversion = Configuration.getInstance().getGeneralConfig().getRVersionNumber();
                URL url = new URL("http://www.algorithm-forge.com/gMCP/version.php?R=" + rversion + "&gMCP=" + version + "&time=" + Configuration.getInstance().getGeneralConfig().getRandomID());
                URL newsURL = new URL("http://cran.r-project.org/web/packages/gMCP/NEWS");
                logger.info((Object)("Get version from " + url.toString()));
                URLConnection conn = url.openConnection();
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                onlineversion = in.readLine();
                String txt = "";
                while ((line = in.readLine()) != null && !line.equals("END")) {
                    txt = txt + line + "\n";
                }
                in.close();
                logger.info((Object)("Get news from " + url.toString()));
                conn = newsURL.openConnection();
                in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String news = "";
                while ((line = in.readLine()) != null && !line.equals("END")) {
                    news = news + line + "\n";
                }
                in.close();
                if (Configuration.getInstance().getGeneralConfig().reminderNewVersion() && VersionComparator.compare(onlineversion, Configuration.getInstance().getGeneralConfig().getVersionNumber()) > 0) {
                    String message = "The newest version on CRAN is " + onlineversion + ". " + "Your version is " + version + ".\n" + "If you want to update, please restart R and use install.packages(\"gMCP\").\n" + "Please note that you can not update gMCP while it is loaded.\n" + "" + "NEWS:";
                    new VersionComparator(message, txt, news, version, onlineversion);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }
}

