/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.datatable;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.datatable.CellEditorE;
import org.af.gMCP.gui.datatable.DataTableModel;
import org.af.gMCP.gui.datatable.EpsilonTableCellRenderer;
import org.af.gMCP.gui.datatable.RDataFrameRef;
import org.af.gMCP.gui.graph.EdgeWeight;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTable
extends JTable {
    public DataTable(RDataFrameRef df) {
        this(new DataTableModel(df));
    }

    public DataTable(DataTableModel dataTableModel) {
        super(dataTableModel);
        this.getTableHeader().setReorderingAllowed(false);
        this.getColumnModel().setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.setAutoResizeMode(0);
        this.setDefaultEditor(EdgeWeight.class, new CellEditorE(null, this));
        this.setDefaultRenderer(EdgeWeight.class, new EpsilonTableCellRenderer());
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    @Override
    public DataTableModel getModel() {
        return (DataTableModel)super.getModel();
    }

    public void update() {
        this.getModel().fireTableStructureChanged();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = super.getPreferredScrollableViewportSize();
        return new Dimension(Math.min(this.getPreferredSize().width, size.width), this.getPreferredSize().height);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getAutoResizeMode() == 0 ? this.getParent().getWidth() > this.getPreferredSize().width : super.getScrollableTracksViewportWidth();
    }

    public String getColumnVar(int col) {
        return this.getModel().getColumnName(col);
    }

    public void setTesting(boolean testing) {
        this.getModel().setTesting(testing);
    }

    @Override
    public void changeSelection(int row, int column, boolean toggle, boolean extend) {
        super.changeSelection(row, column, toggle, extend);
        if (Configuration.getInstance().getGeneralConfig().focusEqualsEdit()) {
            this.editCellAt(row, column);
            this.transferFocus();
            Component editorComponent = this.getEditorComponent();
            if (editorComponent instanceof JTextField) {
                ((JTextField)editorComponent).selectAll();
            }
        }
    }

    public String getRMatrix() {
        return this.getModel().getDataFrame().getRMatrix();
    }

    public void renameNode(int i, String name) {
        this.getModel().df.setName(i, name);
        this.getModel().fireTableStructureChanged();
    }

    public List<String> getNames() {
        return this.getModel().df.getNames();
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component renderer2 = super.prepareRenderer(renderer, row, column);
        renderer2.setEnabled(this.isEnabled());
        return renderer2;
    }
}

