% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/startGUIs.R
\name{graphGUI}
\alias{graphGUI}
\title{Graphical User Interface for graphical described multiple comparison
procedures}
\usage{
graphGUI(graph = "createdGraph", pvalues = numeric(0), grid = 0,
  debug = FALSE, experimentalFeatures = FALSE, envir = globalenv())
}
\arguments{
\item{graph}{Either a variable name for the graph, given as a character
string.  (If it is not a syntactically valid name, \code{\link{make.names}}
is called to change it to a valid one.)  Or an object of class
\code{\link{graphMCP}}.  If the object is modified (even just by updating
the class definition or arranging the nodes) it will be saved in the
specified environment (default is the global environment).}

\item{pvalues}{Numeric value that optionally specifies the p-values.}

\item{grid}{Positive integer that sets the grid size for easier placement of
nodes.  (Therefore grid size 1 allows unrestricted placement and disables
the grid.)  The default grid=0 uses the last used grid value or if the GUI
is started the first time a value of 50.}

\item{debug}{Logical. If \code{TRUE} debug output is printed to the R
console.}

\item{experimentalFeatures}{Logical. If \code{TRUE} some unfinished /
insufficiently tested experimental features are available in the GUI.}

\item{envir}{Environment where the object \var{graph} is located and/or it
should be saved (default is the global environment).}
}
\value{
The function itself returns NULL. But with the GUI a graph can be
created or edited that will be available in R under the specified variable
name after saving in the specified environment.
}
\description{
Starts a graphical user interface for the creation/modification of directed
weighted graphs and applying graphical described multiple comparison
procedures.
}
\details{
See the vignette of this package for further details, since describing a GUI
interface is better done with a lot of nice pictures.

The GUI can save result files if asked to, can look for a new version on CRAN
(if this behaviour has been approved by the user), will change the random seed in
the R session if this is specified by the user in the options (default: no)
and could send bug reports if an error occurs and the user approves it.
}
\examples{
\dontrun{
graphGUI()
pvalues <- c(9.7, 1.5, 0.5, 0.6, 0.4, 0.8, 4)/100
graphGUI(HommelEtAl2007(), pvalues=pvalues)

x <- new.env()
assign("graph", BonferroniHolm(3), envir=x)
graphGUI("graph", envir=x)}
}
\author{
Kornelius Rohmeyer \email{rohmeyer@small-projects.de}
}
\keyword{graphs}
\keyword{misc}

