% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_is.R
\name{graph_is}
\alias{graph_is}
\alias{is_dag}
\alias{is_dagMAT}
\alias{is_ug}
\alias{is_ugMAT}
\alias{is_tug}
\alias{is_tugMAT}
\alias{is_dg}
\alias{is_dgMAT}
\alias{is_adjMAT}
\alias{is.adjMAT}
\alias{is.TUG}
\alias{is.DAG}
\alias{is.DG}
\alias{is.UG}
\title{Check properties of graphs.}
\usage{
is_dag(object)

is_dagMAT(object)

is_ug(object)

is_ugMAT(object)

is_tug(object)

is_tugMAT(object)

is_dg(object)

is_dgMAT(object)

is_adjMAT(object)

is.adjMAT(object)
}
\arguments{
\item{object}{A graph represented as a \code{graphNEL} (graph package),
an \code{igraph} (igraph package), an adjacency matrix or a sparse
adjacency matrix (a \code{dgCMatrix} from the Matrix package).}
}
\description{
Check if a graph is 1) a directed acyclic graph (DAG),
2) a directed graph (DG), 3) an undirected graph (UG), 4) a
triangulated (chordal) undirected graph (TUG).
}
\details{
\itemize{
\item A non-zero value at entry (i,j) in an adjacency matrix A for a
graph means that there is an edge from i to j. If also (j,i) is
non-zero there is also an edge from j to i. In this case we may
think of a bidirected edge between i and j or we may think of the
edge as being undirected.  We do not distinguish between undirected
and bidirected edges in the gRbase package.  On the other hand,
graphNEL objects from the graph package makes such a distinction
(the function \code{edgemode()} will tell if edges are "directed"
or "undirected" in a graphNEL object).
\item The function \code{is_ug()} checks if the adjacency matrix is
symmetric (If applied to a graphNEL, the adjacency matrix is
created and checked for symmetry.)
\item The function \code{is_tug()} checks if the graph is undirected and
triangulated (also called chordal) by checking if the adjacency matrix is
symmetric and the vertices can be given a perfect ordering using maximum
cardinality seach.
\item The function \code{is_dg()} checks if a graph is directed, i.e., that there
are no undirected edges. This is done by computing the elementwise product
of A and the transpose of A; if there are no non--zero entries in this
product then the graph is directed.
\item The function \code{is_dag()} will return \code{TRUE} if all edges are
directed and if there are no cycles in the graph. (This is checked by
checking if the vertices in the graph can be given a topological ordering
which is based on identifying an undirected edge with a bidrected edge).
\item There is a special case, namely if the graph has no edges at all (such that
the adjacency matrix consists only of zeros). Such a graph is both
undirected, triangulated, directed and directed acyclic.
}
}
\section{Synonymous functions}{


The functions
\itemize{
\item \code{is.TUG}/\code{is.DAG}/\code{is.DG}/\code{is.UG}/\code{is.adjMAT}
}

are synonymous with
\itemize{
\item \code{is_tug}/\code{is_dag}/\code{is_dg}/\code{is_ug}/\code{is_adjMAT}.
}

The \code{is.X} group of functions will be deprecated.
}

\examples{

## DAGs
dag_  <- dag(~ a:b:c + c:d:e)

## Undirected graphs
ug_  <- ug(~a:b:c + c:d:e)

## Is graph a DAG?
is_dag(dag_)
is_dag(ug_)

## Is graph an undirected graph
is_ug(dag_)
is_ug(ug_)
 
## Is graph a triangulated (i.e. chordal) undirected graph
is_tug(dag_)
is_tug(ug_)

## Example where the graph is not triangulated
ug2_  <- ug(~ a:b + b:c + c:d + d:a)
is_tug(ug2_)

}
\seealso{
\code{\link{dag}}, \code{\link{ug}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
