## TODO:
## * drag and drop onto tabs, raise on motion,
## * the [ method is not working
## * dispose is forgetting -- not hiding -- the child widget
## * where is my delete method?

setMethod(".gnotebook",
          signature(toolkit="guiWidgetsToolkittcltk"),
          function(toolkit,
                   tab.pos = 3,                          # same as pos= in text
                   closebuttons = FALSE,
                   dontCloseThese = NULL,                 # integer of tabs not to close
                   container=NULL,                           # add to this container
                   ...) {
            
            force(toolkit)

            tt <- getBlock(container)
            gp <- ttkframe(tt)
            nb <- ttknotebook(gp)
            tkpack(nb)                  # pack into gp, gp packed during add(.)
            
            ## tabpos
            if(tab.pos !=3)
              gwCat(gettext("tab.pos is not implemented\n"))

            ## create gnotebook object
            obj = new("gNotebooktcltk", block=gp, widget=nb,
              toolkit=toolkit,ID=getNewID(),e = new.env(),
              closebuttons = as.logical(closebuttons),
              dontCloseThese = ifelse(is.null(dontCloseThese),0,dontCloseThese))


            ## add to container
            add(container, obj, ...)

            
            invisible(obj)
          })

### methods
## return the current tab number
setMethod(".svalue",
          signature(toolkit="guiWidgetsToolkittcltk",obj="gNotebooktcltk"),
          function(obj, toolkit, index=NULL, drop=NULL, ...) {

            nb <- getWidget(obj)
            curTab <- tclvalue(tcl(nb,"select"))
            allTabs <- unlist(strsplit(tclvalue(tcl(nb,"tabs")),"\\s+"))
            which(curTab == allTabs) # 1-based
          })

## set the current tab to value
setReplaceMethod(".svalue",
                 signature(toolkit="guiWidgetsToolkittcltk",obj="gNotebooktcltk"),
                 function(obj, toolkit, index=NULL, ..., value) {


                   nb <- getWidget(obj)
                   n = length(obj)

                   value <- max(1,min(value,n))
                   tcl(nb,"select",value - 1) # 0 -based
                   
                   return(obj)
                 })


## remove the current tab
## this should be called delete -- which is used to remove objects
setMethod(".dispose",
          signature(toolkit="guiWidgetsToolkittcltk",obj="gNotebooktcltk"),
          function(obj, toolkit,  ...) {

            nb <- getWidget(obj)

            theArgs = list(...)
            to.right=ifelse(!is.null(theArgs$to.right), theArgs$to.right,FALSE)
            dontCloseThese = obj@dontCloseThese
            if(dontCloseThese == 0) dontCloseThese = NULL
            deleteOK = function(i) {
              if(is.null(dontCloseThese)) return(TRUE)
              if(i %in% dontCloseThese) return(FALSE)
              return(TRUE)
            }
            cur.pageno = svalue(obj)

            ## we clear out the current page unless there is more!
            inds = 0
            if(to.right) {
              n = length(obj)
              no.right = n - cur.pageno
              if(no.right > 0) 
                inds = no.right:0      # must work from last backwards
            }
            ## clear out would like "hide" here, as then we can
            ## readd. Not working here? why not?
            for(i in inds) {
              j = cur.pageno + i
              if(deleteOK(j)) {
#                tcl(nb,"hide", j - 1)
                tcl(nb,"forget", j - 1)
              }
            }

            if(cur.pageno > 0) {        # error if no pages
              if(cur.pageno <= length(obj))
                svalue(obj) <- cur.pageno
              else
                svalue(obj) <- length(obj)
            }
          })


setMethod(".delete",
          signature(toolkit="guiWidgetsToolkittcltk",obj="gNotebooktcltk"),
          function(obj, toolkit, widget, ...) {
            nb <- getWidget(obj)
            widget <- getBlock(widget)

            tcl(nb,"forget",widget)
          })



### add() is a workhorse method here. Several args available in ...
#add.gNotebook = functionf(obj, value,
#  label="", markup = FALSE,
#  index = NULL, override.closebutton = FALSE, ...) {
setMethod(".add",
          signature(toolkit="guiWidgetsToolkittcltk",obj="gNotebooktcltk",
                    value="guiWidget"),
          function(obj, toolkit, value,  ...) {
            .add(obj, toolkit, value@widget, ...)
          })

setMethod(".add",
          signature(toolkit="guiWidgetsToolkittcltk",obj="gNotebooktcltk",
                    value="gWidgettcltk"),
          function(obj, toolkit, value,  ...) {
            ## in ... we have many possibilies
            ## label -- for setting label  (also look for name)
            ## index for setting the index of page to add
            ## markup -- markup label
            ## override.closebutton -- to not put closebutton even if set in constructor

            nb <- getWidget(obj)
            widget <- getBlock(value)
            
            ## process ...
            theArgs = list(...)                      # for making generic
            if(!is.null(theArgs$label)) {
              label = theArgs$label
            } else if(!is.null(theArgs$name)) {
              label = theArgs$name
            } else {
              label = id(obj)
              if(is.null(label))
                label = "unnamed"
            }
            
            index = if (is.null(theArgs$index)) NULL else theArgs$index
            if(!is.null(theArgs$pageno)) index = theArgs$pageno # also called paegno
            markup = if (is.null(theArgs$markup)) FALSE  else theArgs$markup
            override.closebutton =
              if (is.null(theArgs$override.closebutton))
                FALSE
              else
                as.logical(theArgs$override.closebutton)

            packingOptions = list()
            packingOptions$anchor = if(is.null(theArgs$anchor))
              c(0,0)
            else
              theArgs$anchor
            
            if(!is.null(theArgs$expand) && theArgs$expand) {
              packingOptions$expand = TRUE
              packingOptions$fill = "both"
            }
            
            ## label -- a string in tcltk
            if(!is.character(label))
              label = svalue(label)
            
            
            ## closebutton
            ## closebutton
            file = system.file("images/cancel.gif",package="gWidgets")
            closeb <- tcl("image","create","photo",file=file)
            
            doCloseButton <- FALSE
            
            if(!is.null(obj@closebuttons) &&
               as.logical(obj@closebuttons) &&
               !override.closebutton) {
              doCloseButton <- TRUE
              gwCat(gettext("gnotebook: close buttons are not active\n"))
            } 

            ## where
#            if(!is.null(index)) index = max(1,min(index,n))

            ## add drop motion for labels


            ##
            if(is.null(index)) {
              if(doCloseButton)
                tcl(nb,"add", widget, text=label,
                    image=closeb, compound="right")
              else
                tcl(nb,"add", widget, text=label)
            } else {
              if(doCloseButton)
                tcl(nb,"insert",index-1, widget, text=label,
                    image=closeb, compound="right")
              else
                tcl(nb,"add",index-1, widget, text=label)
            }
          })
            
## Regular R methods treat gnotebook like a vector

## find out number of pages
setMethod(".length",
          signature(toolkit="guiWidgetsToolkittcltk",x="gNotebooktcltk"),
          function(x, toolkit) {
            nb <- getWidget(x)
            as.numeric(tclvalue(tcl(nb,"index","end")))
          })

## return tabnames
setMethod(".names",signature(toolkit="guiWidgetsToolkittcltk",x="gNotebooktcltk"),
          function(x, toolkit) {
            nb <- getWidget(x)
            n <- length(x)
            if(n > 0)
              vals <- sapply(1:n, function(i) tclvalue(tcl(nb,"tab",i - 1, "-text")))
            else
              vals <- NA
            return(vals)
          })

## can assigne with names(x) <-x or even names(x)[i] <- "single name"
setReplaceMethod(".names",
                 signature(toolkit="guiWidgetsToolkittcltk",x = "gNotebooktcltk"),
                 function(x,toolkit, value) {
                   nb <- getWidget(x)
                   n = length(x)
                   
                   if(length(value) != n)
                     stop(gettext("New names for notebook must have proper length"))
                   
                   sapply(1:n, function(i) {
                     tcl(nb,"tab",i-1, text=value[i])
                   })

                   return(x)
                 })


## return widget contained in notebook page i as a  list or single widget
setMethod("[",
          signature(x="gNotebooktcltk"),
          function(x, i, j, ..., drop=TRUE) {
            .leftBracket(x, x@toolkit, i, j, ..., drop=drop)
          })
setMethod(".leftBracket",
          signature(toolkit="guiWidgetsToolkittcltk",x="gNotebooktcltk"),
          function(x, toolkit, i, j, ..., drop=TRUE) {
            nb <- getWidget(x)

            ### XXX Implement this
            gwCat(gettext("gnotebook: [ is not defined in gWidgetstcltk\n"))
            return()

            
            if(missing(i))
              i = 1:length(x)

            
            lst <- sapply(i, function(j) tcl(nb,"tab",j-1))
            if(length(i) == 1)
              return(lst[[1]])
            else
              return(lst)
          })


## Puts widget into a position
setReplaceMethod("[",
                 signature(x="gNotebooktcltk"),
                 function(x, i, j,..., value) {
                   .leftBracket(x, x@toolkit, i, j, ...) <- value
                   return(x)
                 })

setReplaceMethod(".leftBracket",
          signature(toolkit="guiWidgetsToolkittcltk",x="gNotebooktcltk"),
          function(x, toolkit, i, j, ..., value) {
            ##
            nb <- getWidget(x)
            widget <- getBlock(value)

            if(missing(i))
              stop(gettext("Missing value for i"))

            tcl(nb,"add",i - 1, value)
            
          })


### handlers
setMethod(".addhandlerchanged",
          signature(toolkit="guiWidgetsToolkittcltk",obj="gNotebooktcltk"),
          function(obj, toolkit, handler, action=NULL, ...) {
            .addhandlerexpose(obj,toolkit, handler,action)
          })


setMethod(".addhandlerexpose",
          signature(toolkit="guiWidgetsToolkittcltk",obj="gNotebooktcltk"),
          function(obj, toolkit, handler, action=NULL, ...) {
            .addHandler(obj,toolkit,"<<NotebookTabChanged>>",handler, action)
          })

