% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_select.R
\name{galah_select}
\alias{galah_select}
\title{Specify fields for occurrence download}
\usage{
galah_select(..., group = c("basic", "event", "assertions"))
}
\arguments{
\item{...}{zero or more individual column names to include}

\item{group}{\code{string}: (optional) name of one or more column groups to
include. Valid options are \code{"basic"}, \code{"event"} and
\code{"assertion"}}
}
\value{
An object of class \code{data.frame} and \code{galah_select}
specifying the name and type of each column to include in the
call to \code{atlas_counts()} or \code{atlas_occurrences()}.
}
\description{
The living atlases store content on hundreds of different fields, and users
often require thousands or millions of records at a time. To reduce time taken
to download data, and limit complexity of the resulting \code{data.frame}, it is
sensible to restrict the fields returned by \code{\link[=atlas_occurrences]{atlas_occurrences()}}.
This function allows easy selection of fields, or commonly-requested groups
of columns, following syntax shared with \code{dplyr::select()}.
}
\details{
Calling the argument \code{group = "basic"} returns the following columns:
\itemize{
\item \code{decimalLatitude}
\item \code{decimalLongitude}
\item \code{eventDate}
\item \code{scientificName}
\item \code{taxonConceptID}
\item \code{recordID}
\item \code{dataResourceName}
}

Using \code{group = "event"} returns the following columns:
\itemize{
\item \code{eventRemarks}
\item \code{eventTime}
\item \code{eventID}
\item \code{eventDate}
\item \code{samplingEffort}
\item \code{samplingProtocol}
}

Using \code{group = "assertions"} returns all quality assertion-related
columns. The list of assertions is shown by \code{search_fields(type = "assertions")}.
}
\section{Examples}{


Download occurrence records of \emph{Perameles} taken in 2001, only returning
scientific name and event date\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_config(email = "your-email@email.com")
galah_call() |>
  galah_identify("perameles")|>
  galah_filter(year == 2001) |>
  galah_select(scientificName, eventDate) |>
  atlas_occurrences()
}\if{html}{\out{</div>}}

Download occurrence record of \emph{Perameles} taken in 2001, returning the
"basic" group of columns plus the Basis of Record\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_call() |>
  galah_identify("perameles") |>
  galah_filter(year == 2001) |>
  galah_select(group = "basic", basisOfRecord) |>
  atlas_occurrences()
}\if{html}{\out{</div>}}
}

\seealso{
\code{\link[=search_taxa]{search_taxa()}}, \code{\link[=galah_filter]{galah_filter()}} and
\code{\link[=galah_geolocate]{galah_geolocate()}} for other ways to restrict the information returned
by \code{\link[=atlas_occurrences]{atlas_occurrences()}} and related functions; \code{\link[=atlas_counts]{atlas_counts()}}
for how to get counts by levels of variables returned by \code{galah_select}.
}
